$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#opcoes",
        popover: {
          title: "Opções da Tag",
          description:
            "Aqui, podemos marcar algumas opções da tag.",
          position: "top",
        },
      },
      {
        element: "#divImpressora",
        popover: {
          title: "Impressora",
          description:
            "Neste campo, selecionamos qual será a impressora.",
          position: "top",
        },
      },
      {
        element: "#divTipo",
        popover: {
          title: "Tipo da Tag",
          description:
            "Aqui, definimos qual será o tipo da tag.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "O campo de código é preenchido automaticamente após gravar o registro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição para a tag.",
          position: "top",
        },
      },
      {
        element: "#txtQtde",
        popover: {
          title: "Quantidade para Barra",
          description:
            "Aqui, colocamos a quantidade.",
          position: "top",
        },
      },
     
      {
        element: "#txtColunas",
        popover: {
          title: "Colunas da Tag",
          description:
            "Neste campo, definimos quantas colunas a tag terá.",
          position: "top",
        },
      },
     
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a tag.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtCodigo: {
        required: "Informe um código válido.",
      },
      txtDescricao: {
        required: "Informe uma descrição válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $('#txtQtde').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtColunas').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 0
  });

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/tag`;
  });

  const tag = $(window.location.href.split('/')).get(-1);

  carregaDados(tag);

  async function carregaDados(tag) {
    if (tag == 'create') {
      return;
    }
    $.LoadingOverlay("show");
    try {
      const pesquisaParam = {
        tabela: 'CADTAG',
        camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'COLUNAS', 'PADRAO', 'TIPO_IMP', 'QTDE', 'GRAVAR_BARRALOG', 'GRAVAR_EPC'],
        where: [`CODIGO = '${tag}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      insereValor('#txtCodigo', tag);
      insereValor('#txtDescricao', jsonStr[0].DESCRICAO);
      insereValor('#txtQtde', jsonStr[0].QTDE);
      insereValor('#txtColunas', jsonStr[0].COLUNAS);

      $('#cbPadrao').prop('checked', jsonStr[0].PADRAO == 'S');
      $('#cbBarraLog').prop('checked', jsonStr[0].GRAVAR_BARRALOG == 'S');
      $('#cbEpc').prop('checked', jsonStr[0].GRAVAR_EPC == 'S');

      $('#radioExpedicao').prop('checked', jsonStr[0].TIPO == '1');
      $('#radioCodBarra').prop('checked', jsonStr[0].TIPO == '2');
      $('#radioTinturaria').prop('checked', jsonStr[0].TIPO == '3');
      $('#radioKit').prop('checked', jsonStr[0].TIPO == '4');
      $('#radioPacote').prop('checked', jsonStr[0].TIPO == '5');

      $('#radioImpPrincipal').prop('checked', jsonStr[0].TIPO_IMP == 0);
      $('#radioImpSecundaria').prop('checked', jsonStr[0].TIPO_IMP == 1);

    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();

    if (erros != 0) {
      return;
    }

    $.LoadingOverlay('show');
    try {

      const tag = {
        CODIGO: pegaValor('#txtCodigo') == '' ? await RetornaProximo('CADTAG', 'CADTAG', 'CODIGO', 0) : pegaValor('#txtCodigo'),
        DESCRICAO: pegaValor('#txtDescricao'),
        TIPO: isChecked('#radioExpedicao') ? '1' : (isChecked('#radioCodBarra') ? '2' : (isChecked('#radioTinturaria') ? '3' : (isChecked('#radioKit') ? '4' : '5'))),
        COLUNAS: pegaValor('#txtColunas'),
        PADRAO: isChecked('#cbPadrao') ? 'S' : 'N',
        TIPO_IMP: isChecked('#radioImpPrincipal') ? 0 : 1,
        QTDE: pegaValor('#txtQtde'),
        GRAVAR_BARRALOG: isChecked('#cbBarraLog') ? 'S' : 'N',
        GRAVAR_EPC: isChecked('#cbEpc') ? 'S' : 'N',
      };

      const response = await requisicao('POST', '/sisplan/cadastros/v1/tag?', `JSON=${encodeURIComponent(JSON.stringify(tag))}`, null);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/tag` })

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgAlerta(error);
    }
  });

});
