$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de uma tag.",
          position: "right",
        },
      },
      {
        element: "#tabelaTags",
        popover: {
          title: "Tabela Tags",
          description: "Aqui estão as tags cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("TAG");

  $("#txtTag").autocompleta(1, `JSON={ "tabela":"CADTAG", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  $("#btnTag").pesquisa("#txtTag", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADTAG", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Tag", "CADTAG");

  $("#btnLimpaTag").on("click", function () {
    $("#txtTag").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "tag/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  consultaTag();

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await consultaTag();
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtTag").val("");
  });

  async function consultaTag() {
    try {
      $.LoadingOverlay("show");
      const codigo = pegaChave("#txtTag") != "" ? ` AND CODIGO = '${pegaChave("#txtTag")}'` : "";
      const response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", `JSON={ "tabela":"CADTAG", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["1=1 ${codigo}"]}`, null);
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaTags").DataTable({
        destroy: true,
        lengthChange: false,

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODIGO",
          },
          {
            data: "DESCRICAO",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $("#tabelaTags").on("click", "#btn-editar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
          let data = $("#tabelaTags").DataTable().row($(this).parents("tr")).data();
          window.location.href = `tag/${data.CODIGO}`;
        } else {
          msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
      });

      $("#tabelaTags").on("dblclick", "tr", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
          let data = $("#tabelaTags").DataTable().row($(this)).data();
          window.location.href = `tag/${data.CODIGO}`;
        } else {
          msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaTags").unbind("click");

  $('#tabelaTags').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaTags").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    $.LoadingOverlay("show");
    try {
      const valorLinha = data.data();
      const response = await requisicao("DELETE", "/sisplan/cadastros/v1/tag?", `CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
      if (!response) {
        return;
      }
      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      criaMensagemSucesso("Exclusão efetuada com sucesso!", () => { window.location.reload(); });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
