$(document).ready(async function () {

  // $('#tutorial').on('click', function () {
  //   $(document).ready(async function () {
  //     const driver = new Driver({
  //       doneBtnText: 'Sair',
  //       closeBtnText: 'Fechar',
  //       nextBtnText: 'Próximo',
  //       prevBtnText: 'Anterior',
  //       allowClose: false
  //     });
  //     driver.defineSteps([{
  //       element: '#btnFiltros',
  //       popover: {
  //         title: 'Botão Filtros',
  //         description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
  //         position: 'right'
  //       }
  //     },
  //     {
  //       element: '#btnImprimir',
  //       popover: {
  //         title: 'Botão Imprimir',
  //         description: 'Clique aqui para Imprimir um relatório.',
  //         position: 'right'
  //       }
  //     }
  //     ]);
  //     driver.start();
  //   });
  // });

  iniciaTela();

  $('#txtOrdemProducaoRelFaccao').autocompleta(1, `JSON={ "tabela":"OF1", "camposSelect":["NUMERO CHAVE", "CODIGO DESCRICAO"], "where": null}`);
  $('#txtMovimentoRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"FACCAO", "camposSelect":["MOV", "INSUMO"], "where": null, "groupby": ["MOV", "NUMERO"]}`, 'MOV', 'NUMERO');
  $('#txtSetorRelFaccao').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtFaccaoRelFaccao').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
  $('#txtCorRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"CADCOR", "camposSelect":["COR", "DESCRICAO"], "where": null}`, 'COR', 'DESCRICAO');
  $('#txtGrupoRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"GRUPO_MA", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'CODIGO', 'DESCRICAO');
  $('#txtLancamentoRelFaccao').autocompleta(1, `JSON={ "tabela":"FACCAO", "camposSelect":["LANCTO CHAVE", "NUMERO DESCRICAO"], "where": null}`);

  $('#btnOrdemProducaoRelFaccao').pesquisa_serverside(['#txtOrdemProducaoRelFaccao'], ['NUMERO'], ['CODIGO'], '{"tabela":"OF1", "camposSelect":["NUMERO", "CODIGO"], "where": null}', 'Pesquisa de Ordem de Produção');
  $('#btnMovimentoRelFaccao').pesquisa_serversideSel('#txtMovimentoRelFaccao', `{ "tabela":"FACCAO", "camposSelect":["MOV", "NUMERO"], "where": null, "groupby": ["MOV", "NUMERO"]}`, 'Pesquisa de Movimento');
  $('#btnSetorRelFaccao').pesquisa('#txtSetorRelFaccao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":["CODIGO", "DESCRICAO"]}`, 'Pesquisa Setores', 'CADFLUXO', undefined, () => { $("#txtSetorRelFaccao").trigger("blur"); $("#txtSetorRelFaccao").trigger("change"); });
  $('#btnFaccaoRelFaccao').pesquisa_serverside(['#txtFaccaoRelFaccao'], ['CODCLI'], ['NOME'], `{"tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Facção');
  $('#btnCorRelFaccao').pesquisa_serversideSel('#txtCorRelFaccao', `{ "tabela":"CADCOR", "camposSelect":["COR", "DESCRICAO"], "where": null}`, 'Pesquisa de Cores');
  $('#btnGrupoRelFaccao').pesquisa_serversideSel('#txtGrupoRelFaccao', `{ "tabela":"GRUPO_MA", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Grupo');
  $('#btnLancamentoRelFaccao').pesquisa_serverside(['#txtLancamentoRelFaccao'], ['LANCTO'], ['NUMERO'], `{"tabela":"FACCAO", "camposSelect":["LANCTO", "NUMERO"], "where": null}`, 'Pesquisa de Lançamentos');

  $("#btnLimpaOrdemProducaoRelFaccao").on("click", function () {
    $("#txtOrdemProducaoRelFaccao").val("");
    bloqueiaCampoMovimento(true);
  })

  $("#btnLimpaMovimentoRelFaccao").on("click", function () {
    $("#txtMovimentoRelFaccao").empty().trigger('change');
  })

  $("#btnLimpaSetorRelFaccao").on("click", function () {
    $("#txtSetorRelFaccao").val("");
    bloqueiaCampoMovimento(true);
  })

  $("#btnLimpaFaccaoRelFaccao").on("click", function () {
    $("#txtFaccaoRelFaccao").val("");
  })

  $("#btnLimpaCorRelFaccao").on("click", function () {
    $("#txtCorRelFaccao").empty().trigger("change");
  })

  $("#btnLimpaGrupoRelFaccao").on("click", function () {
    $("#txtGrupoRelFaccao").empty().trigger("change");
  })

  $("#btnLimpaLancamentoRelFaccao").on("click", function () {
    $("#txtLancamentoRelFaccao").val("");
  })

  $("#btnLimpaSetorConsumosRelFaccao").on("click", function () {
    $("#txtSetorConsumosRelFaccao").empty().trigger("change");
  })

  $("#btnLimpaParteConsumosRelFaccao").on("click", function () {
    $("#txtParteConsumosRelFaccao").empty().trigger("change");
  })

  $("#btnLimpaAplicacaoConsumosRelFaccao").on("click", function () {
    $("#txtAplicacaoConsumosRelFaccao").empty().trigger("change");
  })

  $("#txtOrdemProducaoRelFaccao").on("change", async function () {
    const ordemProducao = pegaChave(this);
    montaPesquisaFiltrosConsumos();
    await carregaPartes(ordemProducao);
  })

  $("#txtOrdemProducaRelFaccao").on("blur", function () {
    const ordemProducao = pegaChave(this);
    const setor = pegaChave("#txtSetorRelFaccao");
    if (ordemProducao != "" && setor != "") {
      bloqueiaCampoMovimento(false);
      montaPesquisaMovimento(ordemProducao, setor);
    } else {
      bloqueiaCampoMovimento(true)
    }
  })

  $("#btnConsultarRelFaccao").on("click", async function () {
    $.LoadingOverlay("show");
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const setor = pegaChave("#txtSetorRelFaccao");

    try {

      if (ordemProducao == "") {
        throw new Error("Necessário informar o campo número.");
      }

      if (setor == "") {
        throw new Error("Necessário informar o campo setor.");
      }

      await eventoClickBtnConsultarRelFaccao();
    } catch (error) {
      msgAlerta(error.message);
      console.log(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  $("#btnImprimirRelFaccao").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      await imprimirRelFaccao();
    } finally {
      $.LoadingOverlay("hide")
    }
  })

  $("#btnGravarPrecoRelFaccao").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      await gravarPrecoRelFaccao();
      await eventoClickBtnConsultarRelFaccao();
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  $("#btnGravarObservacaoRelFaccao").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      await gravarObservacaoRelFaccao();
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  $("#cbSetorConsumosRelFaccao, #cbParteConsumosRelFaccao, #cbAplicacaoConsumosRelFaccao").on("click", function () {
    if ($("#cbSetorConsumosRelFaccao").prop("checked") || $("#cbParteConsumosRelFaccao").prop("checked") || $("#cbAplicacaoConsumosRelFaccao").prop("checked")) {
      $("#divGrupoRelFaccao").removeClass("d-none");
      $("#divSetorConsumosRelFaccao").removeClass("d-none");
      $("#divParteConsumosRelFaccao").removeClass("d-none");
      $("#divAplicacaoConsumosRelFaccao").removeClass("d-none");
    } else {
      $("#divGrupoRelFaccao").addClass("d-none");
      $("#divSetorConsumosRelFaccao").addClass("d-none");
      $("#divParteConsumosRelFaccao").addClass("d-none");
      $("#divAplicacaoConsumosRelFaccao").addClass("d-none");
    }
  })

  $("#txtSetorRelFaccao").on("change", async function () {
    $.LoadingOverlay("show");
    try {
      const observacao = await retornaObservacaoRelFaccao();
      $("#txtObservacaoRelFaccao").val(observacao);
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  $("#txtSetorRelFaccao").on("blur", function () {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const setor = pegaChave(this);
    if (ordemProducao != "" && setor != "") {
      bloqueiaCampoMovimento(false);
      montaPesquisaMovimento(ordemProducao, setor);
    } else {
      bloqueiaCampoMovimento(true);
    }
  })

  $("#txtParteRelFaccao").on("change", function () {
    if ($(this).val() == "") {
      $("#txtPrecoCertoRelFaccao").val("");
      $("#txtPrecoRelFaccao").val("");
      $("#txtPrecoRelFaccao").attr("disabled", true);
    } else {
      $("#txtPrecoRelFaccao").attr("disabled", false);
    }
    limparGrids();
  })

  $('#abaComposicaoRelFaccao').on('shown.bs.collapse', function () {
    if ($.fn.DataTable.isDataTable("#tabelaComposicaoRelFaccao")) {
      $('#tabelaComposicaoRelFaccao').DataTable().columns.adjust().draw(false);
    }
  });

  function iniciaTela() {
    montaPesquisaFiltrosConsumos();
    retornaHintRelatorio('btnImprimirRelFaccao', 'relfaccao');
  }

  async function consultarRelFaccao() {
    const params = await retornaFiltros();
    const url = `/sisplan/relenviofaccao/v1/consultarelfaccao?`;
    try {

      const response = await requisicao('GET', url, params, '', 360000);

      if (!response) {
        throw new Error("Não foi possível realizar a consulta do relatório de facção.");
      }

      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      }

      return json;

    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    }

  }

  async function retornaFiltros() {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const dataSaida = $("#txtDataSaidaRelFaccao").val();
    const movimento = await formataListas($("#txtMovimentoRelFaccao").val().toString());
    const setor = pegaChave("#txtSetorRelFaccao");
    const descSetor = pegaDescricao("#txtSetorRelFaccao");
    const parte = $("#txtParteRelFaccao").val();
    const faccao = pegaChave("#txtFaccaoRelFaccao");
    const cor = await formataListas($('#txtCorRelFaccao').val().toString());
    const grupo = await formataListas($("#txtGrupoRelFaccao").val().toString());
    const peso = $("#txtPesoRelFaccao").val();
    const lancamento = $("#txtLancamentoRelFaccao").val();
    const checkSetor = $("#cbSetorConsumosRelFaccao").prop("checked");
    const setorConsumos = await formataListas($("#txtSetorConsumosRelFaccao").val().toString());
    const checkParte = $("#cbSetorConsumosRelFaccao").prop("checked");
    const parteConsumos = await formataListas($("#txtParteConsumosRelFaccao").val().toString());
    const checkAplicacao = $("#cbSetorConsumosRelFaccao").prop("checked");
    const aplicacaoConsumos = await formataListas($("#txtAplicacaoConsumosRelFaccao").val().toString());
    const observacao = $("#txtObservacaoRelFaccao").val();


    return `ORDEM_PRODUCAO=${ordemProducao}` +
      `&DATA_SAIDA=${dataSaida}` +
      `&MOVIMENTO=${movimento}` +
      `&SETOR=${setor}` +
      `&DESC_SETOR=${descSetor}` +
      `&PARTE=${parte}` +
      `&FACCAO=${faccao}` +
      `&COR=${cor}` +
      `&GRUPO=${grupo}` +
      `&PESO=${peso}` +
      `&LANCAMENTO=${lancamento}` +
      `&CHECK_SETOR=${checkSetor}` +
      `&SETOR_CONSUMOS=${setorConsumos}` +
      `&CHECK_PARTE=${checkParte}` +
      `&PARTE_CONSUMOS=${parteConsumos}` +
      `&CHECK_APLICACAO=${checkAplicacao}` +
      `&APLICACAO_CONSUMOS=${aplicacaoConsumos}` +
      `&OBSERVACAO=${observacao}`;
  }

  async function gravarPrecoRelFaccao() {
    const url = "/sisplan/relenviofaccao/v1/gravarpreco?";
    // const precoMaximo = await retornaPrecoMaximo();
    const preco = $("#txtPrecoRelFaccao").val();
    const lancamento = $("#txtLancamentoRelFaccao").val();
    const dadosTabelaFaccao = $("#tabelaFaccaoRelFaccao").DataTable().data().toArray();
    try {

      if (dadosTabelaFaccao.length == 0) {
        throw new Error("Não foi possível gravar o preço. Não existem informações no grid.");
      } else {
        // if (preco > precoMaximo) {
        //   throw new Error("Não foi possível realizar a ação. Preço maior que o permitido.")
        // }

        const response = await requisicao("PUT", url, `LANCAMENTO${lancamento}&PRECO=${preco}`, `&JSON=${JSON.stringify(dadosTabelaFaccao)}`, 360000);

        if (!response) {
          throw new Error("Não foi possível gravar o preço.");
        }

        if (response.status != 200) {
          const json = await response.json();
          throw new Error(json.mensagem);
        }

      }

    } catch (error) {
      msgAlerta(error.message);
      console.log(error);
    }

  }

  async function gravarObservacaoRelFaccao() {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const movimento = await formataListas($("#txtMovimentoRelFaccao").val().toString());
    const faccao = pegaChave("#txtFaccaoRelFaccao");
    const setor = pegaChave("#txtSetorRelFaccao");
    const parte = $("#txtParteRelFaccao").val();
    const observacao = $("#txtObservacaoRelFaccao").val();
    const url = `/sisplan/relenviofaccao/v1/observacaomovimento?`;
    const params = `ORDEM_PRODUCAO=${ordemProducao}` +
      `&MOVIMENTO=${movimento}` +
      `&FACCAO=${faccao}` +
      `&SETOR=${setor}` +
      `&PARTE=${parte}` +
      `&OBSERVACAO=${encodeURIComponent(observacao)}`;
    try {

      if (ordemProducao == "") {
        throw new Error("Necessário informar o campo número.");
      }

      if (setor == "") {
        throw new Error("Necessário informar o campo setor.");
      }

      if (parte == "") {
        throw new Error("Necessário informar o campo parte.");
      }

      const response = await requisicao('PUT', url, params, "", 360000);

      if (!response) {
        throw new Error("Não foi possível gravar a observação.");
      }

      if (response.status != 200) {
        const json = await response.json();
        throw new Error(json.mensagem);
      }

      criaMensagemSucesso('Observação gravada com sucesso!', () => { }, () => { });

    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    }

  }

  function montaPesquisaFiltrosConsumos() {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");

    $('#txtSetorConsumosRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"FAC_SETOR", "camposSelect":["SETOR", "DESCRICAO"], "where": ${ordemProducao != "" ? `["FAC_SETOR.NUMERO = '${ordemProducao}'"]` : "null"}, "innerJoin": [{"tabela": "CADFLUXO", "condicao": "FAC_SETOR.SETOR = CADFLUXO.CODIGO"}], "groupBy": ["SETOR", "DESCRICAO"]}`, 'SETOR', 'DESCRICAO');
    $('#txtParteConsumosRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"OF1", "camposSelect":["PCPFT2.PARTE", "TIPO_APL.DESCRICAO"], "where": ${ordemProducao != "" ? `["OF1.NUMERO = '${ordemProducao}'"]` : "null"}, "leftJoin": [{"tabela": "TIPO_APL", "condicao": "OF1.PARTE = TIPO_APL.CODIGO"}, {"tabela": "PCPFT2", "condicao": "PCPFT2.CODIGO = OF1.CODIGO"}], "groupBy": ["PCPFT2.PARTE", "TIPO_APL.DESCRICAO"]}`, 'PARTE', 'DESCRICAO');
    $('#txtAplicacaoConsumosRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"OF1", "camposSelect":["PCPFT2.APLICACAO", "PCPAPL.DESCRICAO"], "where": ${ordemProducao != "" ? `["OF1.NUMERO = '${ordemProducao}'"]` : "null"}, "leftJoin": [{"tabela": "PCPFT2", "condicao": "PCPFT2.CODIGO = OF1.CODIGO"}, {"tabela": "PCPAPL", "condicao": "PCPFT2.APLICACAO = PCPAPL.CODIGO"}], "groupBy": ["APLICACAO", "DESCRICAO"]}`, 'APLICACAO', 'DESCRICAO');

    $('#btnSetorConsumosRelFaccao').pesquisa_serversideSel('#txtSetorConsumosRelFaccao', `{ "tabela":"FAC_SETOR", "camposSelect":["SETOR", "DESCRICAO"], "where": ${ordemProducao != "" ? `["FAC_SETOR.NUMERO = '${ordemProducao}'"]` : "null"}, "innerJoin": [{"tabela": "CADFLUXO", "condicao": "FAC_SETOR.SETOR = CADFLUXO.CODIGO"}], "groupBy": ["SETOR", "DESCRICAO"]}`, 'Pesquisa de Setor');
    $('#btnParteConsumosRelFaccao').pesquisa_serversideSel('#txtParteConsumosRelFaccao', `{ "tabela":"OF1", "camposSelect":["PCPFT2.PARTE", "TIPO_APL.DESCRICAO"], "where": ${ordemProducao != "" ? `["OF1.NUMERO = '${ordemProducao}'"]` : "null"}, "leftJoin": [{"tabela": "TIPO_APL", "condicao": "OF1.PARTE = TIPO_APL.CODIGO"}, {"tabela": "PCPFT2", "condicao": "PCPFT2.CODIGO = OF1.CODIGO"}], "groupBy": ["PCPFT2.PARTE", "TIPO_APL.DESCRICAO"]}`, 'Pesquisa de Parte');
    $('#btnAplicacaoConsumosRelFaccao').pesquisa_serversideSel('#txtAplicacaoConsumosRelFaccao', `{ "tabela":"OF1", "camposSelect":["PCPFT2.APLICACAO", "PCPAPL.DESCRICAO"], "where": ${ordemProducao != "" ? `["OF1.NUMERO = '${ordemProducao}'"]` : "null"}, "leftJoin": [{"tabela": "PCPFT2", "condicao": "PCPFT2.CODIGO = OF1.CODIGO"}, {"tabela": "PCPAPL", "condicao": "PCPFT2.APLICACAO = PCPAPL.CODIGO"}], "groupBy": ["PCPFT2.APLICACAO", "PCPAPL.DESCRICAO"]}`, 'Pesquisa de Aplicação');

  }

  function preencheTabelaFaccao(registros) {

    if ($.fn.DataTable.isDataTable('#tabelaFaccaoRelFaccao')) {
      $("#tabelaFaccaoRelFaccao").DataTable().data().clear().draw(false);
    }

    if (registros.length > 0) {

      const dataSetCols = [];
      const keys = Object.keys(registros[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      criaDataTablePadrao('#tabelaFaccaoRelFaccao',
        false,
        false,
        false,
        false,
        true,
        true,
        false,
        registros,
        dataSetCols);

    }

  }

  function preencheTabelaConsumos(registros) {

    if ($.fn.DataTable.isDataTable("#tabelaConsumosRelFaccao")) {
      $("#tabelaConsumosRelFaccao").DataTable().data().clear().draw(false);
    }

    if (registros.length > 0) {
      const dataSetCols = [];
      const keys = Object.keys(registros[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      criaDataTablePadrao('#tabelaConsumosRelFaccao',
        false,
        false,
        false,
        false,
        true,
        true,
        false,
        registros,
        dataSetCols,
        [34]);

      $('#tabelaConsumosRelFaccao tbody').unbind('click');
      $('#tabelaConsumosRelFaccao tbody').on('click', 'tr', async function () {
        // if ($(this).hasClass('selected')) {
        //     $(this).removeClass('selected');
        // } else {
        $('#tabelaConsumosRelFaccao').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        const dadosRow = $("#tabelaConsumosRelFaccao").DataTable().rows($(this)).data().toArray();
        const jsonComposicao = retornaJsonDadosComposicao(dadosRow.map(dados => dados.COMPOSICAO))
        preencheTabelaComposicao(jsonComposicao);
        // }
      });

      $($('#tabelaConsumosRelFaccao tbody tr')[0]).trigger('click');
    }



  }

  function preencheTabelaComposicao(registros) {
    if ($.fn.DataTable.isDataTable("#tabelaComposicaoRelFaccao")) {
      $("#tabelaComposicaoRelFaccao").DataTable().data().clear().draw(false);
      $("#tabelaComposicaoRelFaccao").DataTable().rows.add(registros).draw(false);
    } else {
      if (registros.length > 0) {
        const dataSetCols = [];
        const keys = Object.keys(registros[0]);
        for (var k in keys) {
          dataSetCols.push({
            'title': keys[k],
            'data': keys[k]
          });
        };

        criaDataTablePadrao('#tabelaComposicaoRelFaccao',
          false,
          false,
          false,
          false,
          true,
          true,
          false,
          registros,
          dataSetCols);
      }
    }
  }

  async function carregaPartes(ordemProducao) {
    try {

      if (ordemProducao == "") {
        return;
      }

      const responsePartes = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "FACCAO", "camposSelect": [" DISTINCT FACCAO.PARTE", "TIPO_APL.DESCRICAO"], "where": ["FACCAO.NUMERO = '${ordemProducao}'"], "leftJoin": [{"tabela": "TIPO_APL", "condicao": "FACCAO.PARTE = TIPO_APL.CODIGO"}], "orderBy": ["FACCAO.PARTE"]}`)

      if (!responsePartes) {
        return;
      }

      const json = await responsePartes.json();
      if (responsePartes.status != 200) {
        msgAlerta(json.RESULT[0].mensagem);
        return;
      }

      await insereValorPesquisaVarios('txtParteRelFaccao', 'PARTE', 'DESCRICAO', json.RESULT[0]);
      $("#txtParteRelFaccao").val("");

      if (json?.RESULT?.[0]?.length === 1) {
        $("#txtParteRelFaccao").val(json?.RESULT?.[0]?.[0]?.PARTE ?? "")
      }


    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    }
  }

  function retornaJsonDadosComposicao(registros) {
    // return registros.map(registro => JSON.parse(registro.replaceAll("%", '"')));
    return JSON.parse(registros.toString().replaceAll("%", '"'));
  }

  async function retornaObservacaoRelFaccao() {
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const setor = pegaChave("#txtSetorRelFaccao");
    const movimento = await formataListas($("#txtMovimentoRelFaccao").val().toString());
    const parte = $("#txtParteRelFaccao").val();
    const url = `/sisplan/relenviofaccao/v1/observacaomovimento?`;
    const params = `ORDEM_PRODUCAO=${ordemProducao}` +
      `&SETOR=${setor}` +
      `&PARTE=${parte}` +
      `&MOVIMENTO=${movimento}`;
    try {

      if (setor == "") {
        return;
      }

      const response = await requisicao('GET', url, params, '', 360000);

      if (!response) {
        throw new Error("Não foi possível consultar a observação.");
      }

      const observacao = await response.text();
      if (response.status != 200) {
        const json = await response.json();
        throw new Error(json.mensagem);
      }

      return observacao;

    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    }

  }

  async function imprimirRelFaccao() {
    try {
      const url = "/sisplan/impressao/v1/relfaccao?";
      const filtros = await retornaFiltros();
      const bImprimeAutomatico = await verificaImprimirAutomatico("RelFaccao");
      const arquivo = await GeraRelatorio(`${url}${filtros}`, "GET", 1000000, false, "RelFaccao");
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error);
    }
  }

  function preencheCamposPreco(precoCerto, preco) {
    $("#txtPrecoCertoRelFaccao").val(precoCerto);
    $("#txtPrecoRelFaccao").val(preco);
  }

  function bloqueiaCampoMovimento(bloquear) {
    $("#txtMovimentoRelFaccao").attr("disabled", bloquear);
    $("#btnMovimentoRelFaccao").attr("disabled", bloquear);
    $("#btnLimpaMovimentoRelFaccao").attr("disabled", bloquear);
    if (bloquear) {
      $("#btnLimpaMovimentoRelFaccao").trigger("click");
    }
  }

  function montaPesquisaMovimento(ordemProducao, setor) {
    $('#txtMovimentoRelFaccao').pesquisa_variosServerside(1, `{ "tabela":"FACCAO", "camposSelect":["MOV", "INSUMO"], "where": ["NUMERO = '${ordemProducao} AND OP = '${setor}''"], "groupby": ["MOV", "NUMERO"]}`, 'MOV', 'NUMERO');
    $('#btnMovimentoRelFaccao').pesquisa_serversideSel('#txtMovimentoRelFaccao', `{ "tabela":"FACCAO", "camposSelect":["MOV", "NUMERO"], "where": ["NUMERO = '${ordemProducao}' AND OP = '${setor}'"], "groupby": ["MOV", "NUMERO"]}`, 'Pesquisa de Movimento');
  }

  function limparGrids() {
    if ($.fn.DataTable.isDataTable('#tabelaFaccaoRelFaccao')) {
      $("#tabelaFaccaoRelFaccao").DataTable().data().clear().draw(false);
    }
    if ($.fn.DataTable.isDataTable('#tabelaConsumosRelFaccao')) {
      $("#tabelaConsumosRelFaccao").DataTable().data().clear().draw(false);
    }
    if ($.fn.DataTable.isDataTable('#tabelaComposicaoRelFaccao')) {
      $("#tabelaComposicaoRelFaccao").DataTable().data().clear().draw(false);
    }
  }

  async function retornaPrecoMaximo() {
    const url = "/sisplan/relenviofaccao/v1/retornaprecomaximo?";
    const ordemProducao = pegaChave("#txtOrdemProducaoRelFaccao");
    const parte = $("#txtParteRelFaccao").val();
    const setor = pegaChave("#txtSetorRelFaccao");
    const params = `ORDEM_PRODUCAO=${ordemProducao}` +
      `&PARTE=${parte}` +
      `&SETOR=${setor}`;

    try {

      const response = await requisicao("GET", url, params, "", 360000);

      if (!response) {
        return 0;
      }

      const json = await response.text();
      if (response.status != 200) {
        return 0;
      }

      return json;

    } catch (error) {
      console.error(error);
    }
  }

  async function eventoClickBtnConsultarRelFaccao() {
    const registros = await consultarRelFaccao();
    preencheTabelaFaccao(registros[0]);
    preencheTabelaConsumos(registros[1]);
    if (registros[0].length > 0) {
      preencheCamposPreco(registros[0][0].CAMPO_PRECO_CERTO, registros[0][0].CAMPO_PRECO)
    }
  }

  await preencheDadosDeMovimentacao()

  async function preencheDadosDeMovimentacao() {
    const storageJson = JSON.parse(localStorage.getItem('objenviorelfaccao'))

    if (storageJson) {
      insereValor('#txtOrdemProducaoRelFaccao', storageJson.NUMERO, storageJson.PRODUTO)
      insereValor('#txtSetorRelFaccao', storageJson.CODSETOR, storageJson.DESCSETOR)
      insereValor('#txtFaccaoRelFaccao', storageJson.CODFACCAO, storageJson.DESCFACCAO)
      $('#txtDataSaidaRelFaccao').val(storageJson.SAIDA)

      await carregaPartes(storageJson.NUMERO);

      $('#txtParteRelFaccao').val(storageJson.PARTE).trigger('change')
      localStorage.removeItem('objenviorelfaccao')

      $("#btnConsultarRelFaccao").trigger("click")
    }
  }

  window.addEventListener('storage', async function (e) {
    if (e.key == 'objenviorelfaccao') {
      await preencheDadosDeMovimentacao()
    }
  })

});