$(document).ready(async function () {

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#divTabelaVendas',
        popover: {
          title: 'Tabela Receber',
          description: 'Aqui, após clicar em consultar ficam os dados das autorizações de pagamento filtradas.',
          position: 'bottom'
        }
      }
      ]);
      driver.start();
    });
  });

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relAP == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relAP: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relAP: novasColunas }))

      $('#tabelaAP').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaAP').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  await preencheOrdenacaoTela('RelReceber');

  await criaConsultaFiltros()

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });


  $('#btnLimparFiltros').on('click', async function () {
    $('#txtAPde').val('');
    $('#txtAPate').val('');
    $('#txtClienteConsulta').val('');

    $('#txtVenctoDe').val('1200-01-01');
    $('#txtVenctoAte').val('2500-12-31');
    $('#txtDataEmiDe').val('1200-01-01');
    $('#txtDataEmiAte').val('2500-12-31');
    $('#txtDigitacaoDe').val('1200-01-01');
    $('#txtDigitacaoAte').val('2500-12-31');
    $('#txtNF').val('');
    $('#txtEntidade').empty().trigger('change');
    $('#txtHistorico').empty().trigger('change');
    $('#txtSituacao').empty().trigger('change');
    $('#txtClasse').empty().trigger('change');
    $('#txtMoeda').empty().trigger('change');
    $('#txtBanco').empty().trigger('change');
    $('#txtConta').empty().trigger('change');
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros() {
    const sTipo = $('input[name="rd"]:checked').val()
    const sAPAberto = $('#cbAPAberto').is(':checked') ? 'S' : 'N';
    // const sRatioCP = $('#cbRateioCP').is(':checked') ? 'S' : 'N';
    const sAntecipacao = $('#cbAntecipacao').is(':checked') ? 'S' : 'N';
    const sAPde = $('#txtAPde').val();
    const sAPate = $('#txtAPate').val();
    const sDataVenctoDe = $('#txtVenctoDe').val();
    const sDataVenctoAte = $('#txtVenctoAte').val();
    const sDataEmissaoDe = $('#txtDataEmiDe').val();
    const sDataEmissaoAte = $('#txtDataEmiAte').val();
    const sDataDigiDe = $('#txtDigitacaoDe').val();
    const sDataDigiAte = $('#txtDigitacaoAte').val();
    const sFornecedor = await formataListas($('#txtEntidade').val().toString());
    const sHistorico = await formataListas($('#txtHistorico').val().toString());
    const sSituacao = await formataListas($('#txtSituacao').val().toString());
    const sClasse = await formataListas($('#txtClasse').val().toString());
    const sMoeda = await formataListas($('#txtMoeda').val().toString());
    const sBanco = await formataListas($('#txtBanco').val().toString());
    const sConta = await formataListas($('#txtConta').val().toString());
    const sNF = $('#txtNF').val();
    const sEmp = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');


    const retorno = ` TIPO=${sTipo}` +
      `&APABERTO=${sAPAberto}` +
      `&ANTECIPACAO=${sAntecipacao}` +
      `&APDE=${sAPde}` +
      `&APATE=${sAPate}` +
      `&DATAVENCTODE=${sDataVenctoDe}` +
      `&DATAVENCTOATE=${sDataVenctoAte}` +
      `&DATAEMISSAODE=${sDataEmissaoDe}` +
      `&DATAEMISSAOATE=${sDataEmissaoAte}` +
      `&DATADIGIDE=${sDataDigiDe}` +
      `&DATADIGIATE=${sDataDigiAte}` +
      `&FORNECEDOR=${sFornecedor}` +
      `&HISTORICO=${sHistorico}` +
      `&SITUACAO=${sSituacao}` +
      `&CLASSE=${sClasse}` +
      `&MOEDA=${sMoeda}` +
      `&BANCO=${sBanco}` +
      `&CONTA=${sConta}` +
      `&NF=${sNF}` +
      `&EMPRESAS_FILTRO=${sEmp}`;
    return retorno;
  }

  retornaHintRelatorio('btnImprimir', 'RelReceberResumido')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimerelap?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelAP&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelAP');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelAP');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      if ($("#txtOrdem option").toArray().length > 0) {
        retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
      }
      try {
        let dataSetCols = [];

        const url = '/sisplan/impressao/v1/consultarelap?';
        const filtros = await retornaFiltros();
        const response = await requisicao('GET', url, filtros,
          null
        );

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');

          $(`#tabelaAP`).DataTable().clear().draw(false);
          Graficos.limpaGrafico(['graficoRelAP', 'graficoRelAP1']);
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        $('#tabelaAP').DataTable({
          destroy: true,
          colReorder: true,
          filter: false,
          autoWidth: true,
          "data": jsonStr,
          "columns": dataSetCols,
          columnDefs: [
            {
              "render": function (data) {
                if (data !== null && data !== undefined && !isNaN(data)) {
                  return parseFloat(data).toLocaleString('pt-BR', {
                    maximumFractionDigits: 2,
                    minimumFractionDigits: 2
                  });
                } else {
                  return '0,00';
                }
              },
              "targets": [19, 20, 23, 24, 25, 38, 39, 45, 46],
              "className": 'pr-4 text-right'
            },
            {
              "targets": [42],
              "className": 'pr-4 text-right'
            },
            {
              "render": function (data, type, row) {
                // alert(navigator['userAgent'])
                let isIE = function () {
                  if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
                    return true;
                  }
                  return false;

                };
                if (isIE()) {
                  x = data.slice(0, 10).split('-');
                  return `${x[2]}/${x[1]}/${x[0]}`;
                }
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;

              },
              "targets": [2, 3, 4, 5]
            }
          ],

        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaAP_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaAP_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/consultarelap?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Autorização de Pagamento', '#tabelaAP');
        })


        $('#tabelaAP').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relAP).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

        const dados = $('#tabelaAP').DataTable().data().toArray();

        Graficos.criarGrafico({
          container: 'graficoRelAP',
          tipo: 'donut',
          dados: dados,
          nomeSerie: 'RelAP',
          colunasAgrupamento: ['DESC_CLASSE_GERENCIAL'],
          colunasValor: ['VALOR_PAGO'],
          title: 'Valor pago por classe'
        })

        Graficos.criarGrafico({
          container: 'graficoRelAP1',
          tipo: 'donut',
          dados: dados,
          nomeSerie: 'RelAP',
          colunasAgrupamento: ['VALOR_PAGO', 'JUROS', 'DESCONTO', 'VAL_DEV'],
          colunasValor: ['VALOR_PAGO', 'JUROS', 'DESCONTO', 'VAL_DEV'],
          title: 'Valores'
        })

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaAP').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relAP ?? [])
  });

  async function criaConsultaFiltros() {
    componenteFiltro('entidade', true);
    componenteFiltro('situacao', true);
    componenteFiltro('historico', true);
    componenteFiltro('classe', true);
    componenteFiltro('moeda', true);
    componenteFiltro('banco', true);
    componenteFiltro('conta', true);
  }
});