$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'geral') {
          if (!$('#DadosGerais').hasClass('show'));
          $('#DadosGerais').collapse('show');
        }
      },
    });

    driver.defineSteps([{
      element: '#divGeral',
      popover: {
        title: 'Pesquisa Completa',
        description: 'Esses são os campos que você informará para realizar a pesquisa e alteração.',
        position: 'top'
      }
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Ao clicar nesse botão você grava os dados inseridos.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});


$(document).ready(async function () {

  let paramTipoTabPreco = await CopiaParametro('VENDA', 5);

  // $('#txtPedido').autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO" ], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}], "where": null}`);
  // $("#btnPedido").pesquisa_serverside(["#txtPedido"], ["NUMERO"], ["CODCLI"], `{"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI" ], leftJoin:[] "where": null }`, "Pesquisa Pedido");

  // $('#txtPedido').autocompleta(1,
  //   `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO" ], 
  //   "innerjoin": [
  //     {"tabela": "PED_ITEN", "condicao": "(PED_ITEN.NUMERO = PEDIDO.NUMERO)"},
  //     {"tabela": "REPRESEN", "condicao": "(REPRESEN.CODREP = PEDIDO.CODREP)"}],
  //   "leftjoin":[
  //     {"tabela": "ENTIDADE", "condicao": "(PEDIDO.CODCLI = ENTIDADE.CODCLI)"}],
  //       "where": ["PEDIDO.NUMERO = PED_ITEN.NUMERO AND PED_ITEN.QTDE <> 0"],
  //       "groupby": ["PEDIDO.NUMERO, ENTIDADE.NOME"]}`);

  $('#btnPedido').pesquisa_serverside(
    ['#txtPedido'],
    ['PED_ITEN.NUMERO'],
    ['ENTIDADE.NOME'],
    `{
      "tabela":"PEDIDO", 
      "camposSelect":["PED_ITEN.NUMERO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "REPRESEN.CODREP", "REPRESEN.NOME"], 
      "leftjoin": [
        {"tabela": "PED_ITEN", "condicao": "(PED_ITEN.NUMERO = PEDIDO.NUMERO)"},
        {"tabela": "ENTIDADE", "condicao": "(PEDIDO.CODCLI = ENTIDADE.CODCLI)"},
        {"tabela": "REPRESEN", "condicao": "(REPRESEN.CODREP = PEDIDO.CODREP)"}
      ],
      "where": ["PED_ITEN.QTDE <> 0"],
      "groupby": ["PED_ITEN.NUMERO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "REPRESEN.CODREP", "REPRESEN.NOME"]
    }`,
    'Pesquisa de Pedido'
  );

  $('#btnLimpaPedido').on('click', function () { $('#txtPedido').val(''); });

  $("#btnProduto").pesquisa_serverside(["#txtProduto"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":["CODIGO", "DESCRICAO" ]}`, "Pesquisa Produto");
  // $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  $('#btnMaterial').pesquisa_serverside(['#txtMaterial'], ['CODIGO'], ['DESCRICAO'], '{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa de Material');
  $('#btnCliente').pesquisa_serverside(["#txtCliente"], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME", "CNPJ" ]}`, "Pesquisa de Cliente");
  $("#btnRepresentante").pesquisa_serverside(["#txtRepresentante"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME", "CNPJ" ]}`, "Pesquisa de Representante");
  $("#btnTabelaPreco").pesquisa_serverside(["#txtTabelaPreco"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ]}`, "Pesquisa Tabela de Preço");
  $("#btnGrupoProduto").pesquisa_serverside(["#txtGrupoProduto"], ["CODCLI"], ["NOME"], `{"tabela":"GRUPO_PA", "camposSelect":[ "CODCLI", "NOME" ]}`, "Pesquisa Grupo de Produto");

  $('#btnLimpaCliente').on('click', function () { $('#txtCliente').val(''); });
  $('#btnLimpaRepresentante').on('click', function () { $('#txtRepresentante').val(''); });
  $('#btnLimpaTabelaPreco').on('click', function () { $('#txtTabelaPreco').val(''); });
  $('#btnLimpaProduto').on('click', function () { $('#txtProduto').val(''); });
  $('#btnLimpaMaterial').on('click', function () { $('#txtMaterial').val(''); });
  $('#btnLimpaGrupoProduto').on('click', function () { $('#txtGrupoProduto').val(''); });

  $('#tabelaPedido').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    lengthChange: false,
    autoWidth: true,
    destroy: true,
    columnDefs: [
      {
        "render": function (data) {
          if (data !== null && data !== undefined && !isNaN(data)) {
            return parseFloat(data).toLocaleString('pt-BR', {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          } else {
            return '0,00';
          }
        },
        "targets": [10, 11],
        "className": 'pr-4 text-right'
      },
      {
        "targets": [8, 9],
        "className": 'pr-4 text-right'
      }
    ]
  });

  $('#btnConsultar').on('click', async function () {
    $('#txtValorOriginal').val('0.00');
    $('#txtValorRecalculo').val('0.00');
    // insereValor('#txtCliente', pegaDescricao('#txtPedido'), { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: pegaDescricao('#txtPedido') });
    if ($('#tabelaPedido')[0].rows.length > 0) {
      await limpaTabela();
    }

    await buscaDadosPedidos();

    adicionaVirgula('#txtValorOriginal');
    adicionaVirgula('#txtValorRecalculo');

    $('#txtValorOriginal').focus();
    $('#txtValorRecalculo').focus();

  });

  // $('#txtPedido').on('blur', function () {
  //   $('#btnConsultar').trigger('click');
  // });

  $('#txtPedido').on('change', function () {
    $('#txtTabelaPreco').val('');
    $('#tabelaPedido')
    while ($('#selectPrazo')[0].options.length) {
      $('#selectPrazo')[0].remove(0);
    }
    $('#tabelaPedido').empty();
    $('#tabelaPedido').DataTable().clear().draw(false);
  });

  $('#txtPedido').on('blur', async function () {
    await validaSePermitePedido()
  });

  function buscaParams() {
    // let sNumero = pegaChave('#txtPedido')
    let sManterDescItem = $('#cbManterDescontoItem').is(':checked') ? '1' : '0';
    let sAttTabPreco = $('#cbAtualizarTabPrecoPedido').is(':checked') ? '1' : '0';
    // let sTabPreco = pegaChave('#txtTabelaPreco');

    let retorno = //`&NUMERO=${sNumero}` +
      `&MANTERDESCITEM=${sManterDescItem}` +
      `&ATTPRECOTAB=${sAttTabPreco}`;
    // `&TABPRECO=${sTabPreco}`;

    return retorno;
  };

  $('#btnGravar').on('click', async function () {
    $('#txtValorOriginal').val('0.00');
    $('#txtValorRecalculo').val('0.00');
    $.LoadingOverlay('show');
    try {
      const ListaItensPedido = buscaDadosTabela();
      const params = buscaParams();
      if (!$('#tabelaPedido').DataTable().rows().length) {
        throw msgAlerta('Nenhum registro para alterar, verifique');
      }

      ListaItensPedido.map((item) => {
        if (item.QTDE == 0) {
          throw msgAlerta('Existem itens sem quantidade, impossível continuar!');
        }
      })

      let objeto = { ListaItensPedido };

      let response = await requisicao('POST', `/sisplan/pedido/v1/recalculopedido?`, '', `JSON=${JSON.stringify(objeto)}${params}`, 15000);

      if (!response) {
        return;
      }

      $('#btnConsultar').trigger('click');
    } catch (err) {
      msgAlerta(`Erro ao gravar os dados: ${err}`)
    } finally {
      $.LoadingOverlay('hide');
      msgAlerta('Gravação concluida, os valores foram alterados.')
    }
  });

  $('#btnBuscaCod').on('click', async function () {
    await buscaCodigoProduto();
  });

  $('#btnRecalPedido').on('click', function () {
    const tabelaPedido = $('#tabelaPedido').DataTable().rows().data().toArray();
    let indice = $('#txtIndice').val();
    tabelaPedido.map((item, i) => {
      $(`#txtPreco_${i} `).val('');
      $(`#txtPreco_${i} `).val(TruncaDecimaisNova(2, item[11] * indice));
    });
    calcularRecalculo();
    adicionaVirgula('#txtValorRecalculo');
    $('#txtValorRecalculo').focus();
  });

  // $('.inputPreco').$(this).on('blur', function () {
  //   if ($('.inputPreco').$(this) < $('#tabelaPedido').DataTable().row($(this)).data()) {
  //     msgAlerta('Novo preço é menor que o preço original, insira a senha de supervisor para continuar!', async function () { return })
  //   }
  // })

  // $('#btnVoltar').on('click', async function () {
  //   window.location.href = `${ BASE_URI } /recal_pedido`;
  // });

  // $('#txtPedido').on('blur', async function () {
  //   if (!!await buscaValor('REGIAO_PRAZO', 'PRAZO', 'REGIAO', pegaChave('#txtTabelaPreco'))) {
  //     await carregaPrazo();
  //   } else if ($('#selectPrazo').val() == 0 || $('#selectPrazo') == 00) {
  //     await carregaPrazoPadrao();
  //   }
  // });

  async function precoCorTam(sCodigo, sTabela, sCor, sTam) {
    let response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela": "PRECO_COR_TAM", "camposSelect": ["PRECO"], "where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND TAM = '${sTam}' AND REGIAO = '${sTabela}'"]}`, 15000);

    let jsonStr = await response.json();
    console.log(jsonStr);
    if (!jsonStr.RESULT[0][0]) {
      return 0
    } else {
      return jsonStr.RESULT[0][0].PRECO;
    }
  };

  function alteraFocus() {
    const tabelaPedido = $('#tabelaPedido').DataTable().rows().data().toArray();
    for (let i = 0; i < tabelaPedido.length; i++) {
      const inputElement = $('#txtPreco_' + i);
      inputElement.on('blur', function () {
        const scrollTop = $(window).scrollTop(); // Obtenha a posição vertical atual da página
        $('#txtValorRecalculo').focus();
        $(window).scrollTop(scrollTop); // Mantenha a posição vertical da página
      });
    }
  }



  $('#btnPrecoTab').on('click', async function () {
    $.LoadingOverlay("show");
    try {
      if (!$('#txtTabelaPreco').val()) {
        throw msgAlerta('É necessário informar uma tabela de preço, verifique!');
      }
      $('#txtValorRecalculo').val('0.00')
      if ($('#tabelaPedido').DataTable().rows().data().length == 0) {
        throw msgAlerta('Nenhum pedido encontrado, verifique!');
      }

      const tabelaPedido = $('#tabelaPedido').DataTable().rows().data().toArray();
      for (let i = 0; i < tabelaPedido.length; i++) {
        if (paramTipoTabPreco == '1') {
          $(`#txtPreco_${i}`).val(await precoCorTam(tabelaPedido[i][2], pegaChave('#txtTabelaPreco'), tabelaPedido[i][5], tabelaPedido[i][7]));
        } else {
          $(`#txtPreco_${i}`).val(await precoProduto(tabelaPedido[i][2], pegaChave('#txtTabelaPreco'), $('#selectPrazo').val()));
        }
      }
      calcularRecalculo();
    }
    finally {
      $.LoadingOverlay("hide");
      adicionaVirgula('#txtValorRecalculo');
      $('#txtValorRecalculo').focus();
    }
  });

  async function buscaCodigoProduto() {
    const tabelaPedido = $('#tabelaPedido').DataTable().rows().data().toArray();
    let controle = 1;

    for (let i = 0; i < tabelaPedido.length; i++) {
      // let codigo = tabelaPedido[i][2]
      // let cod = tabelaPedido[i][5]
      // let tam = tabelaPedido[i][7]
      let response = await requisicao(
        'GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela": "PA_ITEN", "camposSelect": ["BARRACLI"], "where": ["CODIGO = '${tabelaPedido[i][2]}' AND COR = '${tabelaPedido[i][5]}' AND TAM = '${tabelaPedido[i][7]}'"]}`, 15000);

      let jsonStr = await response.json();
      $(`#txtBarraCli_${controle}`).val(jsonStr.RESULT[0].BARRACLI);
      controle++
    }
  }

  function carregaPrazoPadrao() {
    while ($('#selectPrazo')[0].options.length) {
      $('#selectPrazo')[0].remove(0);
    }
    for (let i = 0; i <= 13; i++) {
      $('#selectPrazo').append($('<option>', {
        value: (i * 7).toString().padStart(2, "0"),
        text: (i * 7).toString().padStart(2, "0")
      }));
    }
  }

  $('#txtIndice').on('change', function () {
    if (!$('#txtIndice').val()) {
      $('#txtIndice').val('1')
    }
  });

  async function preenchePrazos(tabela) {
    if (!!await buscaValor('REGIAO_PRAZO', 'PRAZO', 'REGIAO', tabela)) {
      await carregaPrazo();
    } else if (($('#selectPrazo').val() == 0) || ($('#selectPrazo').val() == '00')) {
      carregaPrazoPadrao();
    }
  }

  async function buscaDadosPedidos() {
    if (!($('#txtPedido').val() || $('#txtProduto').val() || $('#txtMaterial').val() || $('#txtCliente').val() || $('#txtRepresentante').val() || $('#txtTabelaPreco').val())) {
      msgErro('Preencha ao menos um campo para realizar a pesquisa: Pedido, Cliente, Representante, Produto, Tabela de Preço.');
      return;
    }
    const whereCompleto = await montaWherePesquisa();
    const ligacaoCompleta = await montaLigacoesPesquisa();
    const camposCompleto = await montaCamposSelect();
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");

      for (let i = 0; i < camposCompleto.colunas.length; i++) {
        dataSetCols.push({
          'title': camposCompleto.colunas[i],
          'data': i
        });
      }

      let response = await requisicao(
        'GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela": "PEDIDO", "camposSelect":${camposCompleto.camposSelect}, "leftjoin": [${ligacaoCompleta}], "where": ["1=1 ${whereCompleto}"]}`, 15000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        throw msgErro('Não foi possível buscar os dados.');
      }

      let jsonStr = await response.json();

      insereValor('#txtTabelaPreco', jsonStr.RESULT[0][0].TAB_PRE, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: jsonStr.RESULT[0][0].TAB_PRE });
      jsonStr.RESULT[0].map((item, i) => {
        // let linha = $('#tabelaPedido').DataTable().data().toArray().length + 1;
        $('#tabelaPedido').DataTable().row.add([
          item.NUMERO,
          item.ORDEM,
          item.CODIGO,
          item.CODIGO2,
          item.DESCRICAO,
          item.COR,
          item.DESC_COR,
          item.TAM,
          item.QTDE,
          item.QTDE_F,
          TruncaDecimaisNova(2, item.DESC_ITEM),
          TruncaDecimaisNova(2, item.PRECO_ORIG),
          `<input style="width:15em;" type="text" id="txtPreco_${i}" class="input-default inputPreco form-control" value="${TruncaDecimaisNova(2, item.PRECO)}">`,
          // `<input style="width:15em;" type="text" id="txtPedCli_${linha}" class="input-default form-control">`,
          // `<input style="width:15em;" type="text" id="txtCodItemCli_${linha}" class="input-default form-control">`,
          // `<input style="width:15em;" type="text" id="txtBarraCli_${linha}" class="input-default form-control">`
        ]).draw(false);
      });

      $('.inputPreco').on('blur', function () {
        $('#txtValorRecalculo').val('0.00');
        calcularRecalculo();
      })

      $('.inputPreco').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
      });

      await preenchePrazos(jsonStr.RESULT[0][0].TAB_PRE);
      $('#selectPrazo').prop('disabled', false);

      calcularRecalculo();
      calcularValorOriginal();

    } catch (error) {
      console.error(error);
      msgErro('Nenhum pedido encontrado.');

    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function calcularRecalculo() {
    let valorRecalculo = TruncaDecimaisNova(2, $('.inputPreco').toArray().reduce((valorTotal, input, i) => valorTotal + ($('#tabelaPedido').DataTable().row(i).data()[8] * parseFloat($(input).val())), 0).toString());
    $('#txtValorRecalculo').val(valorRecalculo);
    await alteraFocus();
  };

  function calcularValorOriginal() {
    $('#tabelaPedido').DataTable().rows().data().map((item, i) => {
      $('#txtValorOriginal').val(TruncaDecimaisNova(2, +$('#txtValorOriginal').val() + ($('#tabelaPedido').DataTable().row(i).data()[8] * +$(`#txtPreco_${i}`).val())));
    });
  }

  async function montaWherePesquisa() {
    let where = '';
    where += pegaChave('#txtPedido') != '' ? ` AND PEDIDO.NUMERO = '${pegaChave('#txtPedido')}'` : '';
    where += pegaChave('#txtProduto') != '' ? ` AND PED_ITEN.CODIGO = '${pegaChave('#txtProduto')}'` : '';
    where += pegaChave('#txtMaterial') != '' ? ` AND PED_ITEN.CODIGO = '${pegaChave('#txtMaterial')}'` : '';
    where += pegaChave('#txtCliente') != '' ? ` AND PEDIDO.CODCLI = '${pegaChave('#txtCliente')}'` : '';
    where += pegaChave('#txtRepresentante') != '' ? ` AND PEDIDO.CODREP = '${pegaChave('#txtRepresentante')}'` : '';
    where += pegaChave('#txtTabelaPreco') != '' ? ` AND PEDIDO.TAB_PRE = '${pegaChave('#txtTabelaPreco')}'` : '';
    where += $('#cbSemExpedicao').is(':checked') ? ` AND NOT EXISTS (SELECT PEDIDO3.NUMERO FROM [PEDIDO3] WHERE PEDIDO3.NUMERO = ITEM.NUMERO` : '';
    where += ` AND PED_ITEN.QTDE > 0`;

    // where += $('#dtCancalamentoDe').val() != '' ? ` AND PEDIDO.DT_CANC >= '${$('#dtCancalamentoDe').val()}'` : '';
    // where += $('#dtCancelamentoAte').val() != '' ? ` AND PEDIDO.DT_CANC <= '${$('#dtCancelamentoAte').val()}'` : '';
    // where += ` AND ITEM.QTDE > 0`;
    // where += pegaChave('#txtCliente') != '' ? ` AND ENTIDADE.CODCLI = ${pegaChave('#txtCliente')}` : '';
    // where += pegaChave('#txtCliente') != '' ? ` AND ENTIDADE.CODCLI = ${pegaChave('#txtCliente')}` : '';
    return where;
  }


  async function montaLigacoesPesquisa() {
    return `{"tabela": "PED_ITEN", "condicao": "(PED_ITEN.NUMERO = PEDIDO.NUMERO)"},` +
      `{"tabela": "PRODUTO", "condicao": "(PRODUTO.CODIGO = PED_ITEN.CODIGO)"},` +
      `{"tabela": "MATERIAL", "condicao": "(MATERIAL.CODIGO = PED_ITEN.CODIGO)"},` +
      `{"tabela": "FAIXA_ITEN", "condicao": "(FAIXA_ITEN.FAIXA = PRODUTO.FAIXA AND PED_ITEN.TAM = FAIXA_ITEN.TAMANHO)"},` +
      `{"tabela": "CADCOR", "condicao": "(PED_ITEN.COR = CADCOR.COR)"}`;
  };

  async function montaCamposSelect() {
    let camposSelect = [];
    let colunas = [];

    camposSelect = `["PED_ITEN.NUMERO", "PED_ITEN.ORDEM", "PED_ITEN.CODIGO", "CASE WHEN PED_ITEN.TIPO = 'P' THEN PRODUTO.CODIGO2 ELSE MATERIAL.CODIGO2 END CODIGO2",
    "CASE WHEN PED_ITEN.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO", "CASE WHEN PED_ITEN.TIPO = 'P' THEN PRODUTO.GRUPO ELSE MATERIAL.GRUPO END GRUPO",
    "PED_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PED_ITEN.TAM", "PED_ITEN.QTDE", "PED_ITEN.PRECO", "PED_ITEN.PRECO PRECO_ORIG", "PED_ITEN.PED_CLI", "PED_ITEN.COD_ITENCLI", 
    "PED_ITEN.QTDE_F", "FAIXA_ITEN.POSICAO", "PED_ITEN.DESC_ITEM", "PEDIDO.TAB_PRE"]`;

    colunas = ["NUMERO", "ORDEM", "CODIGO", "CODIGO2", "DESCRICAO", "COR", "DESC_COR", "TAM", "QTDE", "QTDE_F", "DESC_ITEM", "TABPRECO", "PRECO", "PED", "COD", "BARRACLI"];
    ''
    return objeto = {
      camposSelect: camposSelect,
      colunas: colunas
    };
  };

  async function precoProduto(sCodigo, sTabela, sPrazo) {
    let response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela": "TABPRECO", "camposSelect": ["PRECO_${sPrazo} PRECO"], "where": ["CODIGO = '${sCodigo}' AND REGIAO = '${sTabela}'"]}`, 15000);
    let jsonStr = await response.json();
    if (jsonStr.RESULT[0][0]) {
      return jsonStr.RESULT[0][0].PRECO;
    } else {
      return 0;
    }
  };

  async function carregaPrazo() {
    while ($('#selectPrazo')[0].options.length) {
      $('#selectPrazo')[0].remove(0);
    }
    try {
      let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"REGIAO_PRAZO", "camposSelect":[ "REGIAO", "PRAZO", "ORDEM"], "where": ["1=1 AND REGIAO='${pegaChave('#txtTabelaPreco')}'"], "orderBy": ["ORDEM"]}`, null);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      if (!!jsonStr) {
        for (let i = 0; i < jsonStr.RESULT[0].length; i++) {
          $('#selectPrazo').append($('<option>', {
            value: jsonStr.RESULT[0][i].PRAZO.toString().padStart(2, "0"),
            text: jsonStr.RESULT[0][i].PRAZO.toString().padStart(2, "0")
          }));
        }
      }

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  function buscaDadosTabela() {
    const tabela = $('#tabelaPedido').DataTable().rows().data().toArray();
    let listaItensPedido = tabela.map((item, i) => {
      return {
        NUMERO: item[0],
        ORDEM: item[1],
        CODIGO: item[2],
        COR: item[5],
        TAM: item[7],
        QTDE: item[8],
        DESC_ITEM: item[10],
        PRECO_ORIG: item[11],
        PRECO: $('#txtPreco_' + i).val(),
      };
    })
    return listaItensPedido;
  }

  async function limpaTabela() {
    $('#tabelaPedido').DataTable().clear().draw(false);
  };

  async function validaSePermitePedido() {
    let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"PED_ITEN", "camposSelect":[ "COUNT(DISTINCT(TIPO)) TIPO"], "where": ["1=1 AND NUMERO='${pegaChave('#txtPedido')}'"]}`, null);
    if (!response) {
      return;
    }
    let jsonStr = await response.json();
    if (!jsonStr.RESULT[0][0].TIPO === 1) {
      throw msgAlerta('Pedido cadastrado com produto e material, impossível continuar!');
    }
  }

  $('input[name="tipoConsulta"]').change(function () {
    let tipoSelecionado = $(this).val();

    if (tipoSelecionado === 'M') {
      $('#labelProduto').addClass('d-none');
      $('#labelMaterial').removeClass('d-none');
    } else {
      $('#labelMaterial').addClass('d-none');
      $('#labelProduto').removeClass('d-none');
    }
  });

  function adicionaVirgula(elemento) {
    $(elemento).on('focus', function () {
      let valor = $(this).val();
      let pontoIndex = valor.lastIndexOf('.');
      let virgulaIndex = valor.lastIndexOf(',');

      if (pontoIndex > virgulaIndex) {
        let parteInteira = valor.substring(0, pontoIndex);
        let parteDecimal = valor.substring(pontoIndex + 1);

        // Remove qualquer formatação existente (vírgulas e pontos)
        parteInteira = parteInteira.replace(/[,.]/g, '');
        parteDecimal = parteDecimal.replace(/[,.]/g, '');

        // Formata a parte inteira com os separadores de milhares
        parteInteira = parteInteira.replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.');

        // Reconstroi o valor formatado com a vírgula decimal
        let novoValor = parteInteira + ',' + parteDecimal.padEnd(2, '0');

        $(this).val(novoValor);
      } else if (virgulaIndex > -1) {
        // Valor já contém vírgula decimal, formatar apenas a parte inteira
        let parteInteira = valor.substring(0, virgulaIndex);

        // Remove qualquer formatação existente (vírgulas e pontos)
        parteInteira = parteInteira.replace(/[,.]/g, '');

        // Formata a parte inteira com os separadores de milhares
        parteInteira = parteInteira.replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.');

        let novoValor = parteInteira + valor.substring(virgulaIndex);

        $(this).val(novoValor);
      }
    });
  }



}); 