$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaOperacaoFiscal',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma operação fiscal.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaOperacaoFiscal',
                popover: {
                    title: 'Tabela Regras',
                    description: 'Aqui estão os dados das operações fiscais cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("OPERACAOFISCAL");
    const sWhereOperFiscal = await retornaWhereOperFiscalUsuario(getCookie('cod_usuario'));

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (colunas == null || colunas.operacaoFiscal == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, operacaoFiscal: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
        $('#tabelaOperacaoFiscal').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text().trim(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.operacaoFiscal ?? [], [])
    })

    // autocompleta
    $('#txtOperacao').autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao descricao"], "where": ${sWhereOperFiscal}}`);
    // pesquisa
    $('#btnOperacao').pesquisa('#txtOperacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"], "where": ${sWhereOperFiscal}}`, 'Pesquisa Operação Fiscal', 'oper_fiscal');
    // limpacampo
    $('#btnAOperacao').on('click', function () {
        $('#txtOperacao').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovaOperacaoFiscal').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "operacaofiscal/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $("#tabelaOperacaoFiscal").on('click', "#btnAnexos", async function () {
        const data = $('#tabelaOperacaoFiscal').DataTable().rows($(this).parents('tr')).data();

        await abreModalAnexos(data[0].CODIGO, data[0].DESCRICAO, 'OPERACAOFISCAL');
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '    <button class="dropdown-item" type="button" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
            '</div>';
        return retorno;
    };

    consultaOperacaoFiscal();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaOperacaoFiscal(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtOperacao').val('');
    });

    async function consultaOperacaoFiscal(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;
            let codigo = pegaChave('#txtOperacao') != '' ? ` AND CODIGO = '${pegaChave('#txtOperacao')}'` : sWhereOperFiscal != 'null' ? sWhereOperFiscal.replace('CODIGO', 'AND CODIGO').slice(2, -2) : '';
            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"], "where": ["1=1 ${codigo}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"], "where": ["1=1 ${codigo}"]}`, null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaOperacaoFiscal').DataTable({
                destroy: true,
                serverside: true,
                search: false,
                scrollX: true,
                scrollY: '55vh',
                pageLength: 25,
                autoWidth: true,
                lengthChange: true,
                sortable: true,
                paging: true,
                filter: true,
                info: true,
                order: [],
                destroy: true,
                colReorder: true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "CODIGO"
                },
                {
                    "data": "DESCRICAO"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $('#tabelaOperacaoFiscal_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaOperacaoFiscal_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
            $('#buttonExcel').prop('title', 'Exportar');

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show')
                try {
                    $('#modal-ColunasVisiveis').modal('show');
                } finally {
                    $.LoadingOverlay('hide')
                }
            });

            $("#btnConfirmarColunas").off();
            $("#btnConfirmarColunas").on("click", async function () {
                try {
                    $.LoadingOverlay("show");
                    const tabela = '#tabelaOperacaoFiscal'

                    const novasColunas = retornaNovasColunasInvisiveis();
                    localStorage.setItem(
                        "colunasInvisiveisRelatorios",
                        JSON.stringify({
                            ...colunas,
                            operacaoFiscal: novasColunas,
                        })
                    );

                    $(tabela).DataTable().columns().visible(true);

                    $(tabela)
                        .DataTable()
                        .columns()
                        .every(function () {
                            const colAtual = String(this.dataSrc());
                            if (novasColunas.indexOf(colAtual) != -1) {
                                this.visible(false);
                            }
                        });

                } finally {
                    $.LoadingOverlay("hide");
                    $("#modal-ColunasVisiveis").modal("hide");
                }
            });

            $('#buttonExcel').off()
            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaOperacaoFiscal").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório de Regras', '', '', 999, false, false, dados);
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#tabelaOperacaoFiscal').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaOperacaoFiscal').DataTable().row($(this).parents('tr')).data();
            // var registroLiberado = await verificarRegistro('OPERACAOFISCAL', data.CODIGO)
            // if (registroLiberado) {
            window.location.href = `operacaofiscal/${data.CODIGO}`;
            // }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaOperacaoFiscal').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaOperacaoFiscal').DataTable().row($(this)).data();
            // var registroLiberado = await verificarRegistro('OPERACAOFISCAL', data.CODIGO)
            // if (registroLiberado) {
            window.location.href = `operacaofiscal/${data.CODIGO}`;
            // }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaOperacaoFiscal').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaOperacaoFiscal").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/OperacaoFiscal?", `CODIGOOPERACAOFISCAL=${encodeURIComponent(valorLinha.CODIGO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});