$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#txtQualidade',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'bottom'
        }
      },
      {
        element: '#txtData',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'bottom'
        }
      },
      {
        element: '#txtDeposito',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtSetor',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtBarra',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#tipos',
        popover: {
          title: 'Tipo',
          description: 'Aqui você define qual tipo de quer usar.',
          position: 'top'
        }
      },
      {
        element: '#opcoes',
        popover: {
          title: 'Opções',
          description: 'Aqui você pode selecionar algumas opções.',
          position: 'top'
        }
      },
      {
        element: '#tabelaInventarioMaterial',
        popover: {
          title: 'Tabela Inventário de Material',
          description: 'Aqui ficam todos os dados dos itens que forem bipados.',
          position: 'top'
        }
      },
      {
        element: '#btnCancelar',
        popover: {
          title: 'Botão Cancelar',
          description: 'Ao clicar nesse botão você cancela todos os itens passados.',
          position: 'left'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Botão Gerar',
          description: 'Clique aqui para gerar o inventário.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  await setarDataAtual('txtData');
  await setarDataAtual('dtFabricacao');

  let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

  if (colunas == null || colunas.inventarioMaterial == undefined) {
    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, inventarioMaterial: [] })
    );
    colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
  }

  $("#btnConfirmarColunas").on("click", async function () {
    try {
      $.LoadingOverlay("show");

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem(
        "colunasInvisiveisRelatorios",
        JSON.stringify({ ...colunas, inventarioMaterial: novasColunas })
      );

      $("#tabelaInventarioMaterial").DataTable().columns().visible(true);

      $("#tabelaInventarioMaterial")
        .DataTable()
        .columns()
        .every(function () {
          const colAtual = String(this.dataSrc());
          if (novasColunas.indexOf(colAtual) != -1) {
            this.visible(false);
          }
        });
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-ColunasVisiveis").modal("hide");
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaInventarioMaterial').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.inventarioMaterial ?? [])
  })

  $('#txtQtdeAuxModal').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtPesoManual').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  let filtroSetor;
  filtroSetor = await buscaSetorUsuario();
  filtroSetor = filtroSetor == '' ? null : `"CODIGO IN (${filtroSetor})"`;

  let filtroDeposito;
  filtroDeposito = await buscaDepositoEmpresaUsuario();
  filtroDeposito = filtroDeposito == '' ? null : `CODIGO IN (${filtroDeposito})`;


  $('#txtSetor').autocompleta(
    1,
    `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": [${filtroSetor}]}`,
    [],
    [],
    [],
    () => {
      if ($('#txtSetor').val()) {
        $('#txtSetor').attr('disabled', true)
        $('#btnSetor').attr('disabled', true)
        $('#btnLimpaSetor').attr('disabled', true)
      }
    });

  $("#btnSetor").pesquisa_array(
    ["#txtSetor"],
    ["CHAVE"],
    ["DESCRICAO"],
    `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADFLUXO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": [${filtroSetor}]}`,
    "Pesquisa Setor",
    "CADFLUXO",
    () => {
      if ($('#txtSetor').val()) {
        $('#txtSetor').attr('disabled', true)
        $('#btnSetor').attr('disabled', true)
        $('#btnLimpaSetor').attr('disabled', true)
      }
    }
  );
  $('#btnLimpaSetor').on('click', function () {
    $('#txtSetor').val('');
  });

  $("#txtDeposito").autocompleta(
    1,
    `JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["${filtroDeposito}"]}`,
    [],
    [],
    [],
    () => {
      if ($('#txtDeposito').val()) {
        $('#txtDeposito').attr('disabled', true)
        $('#btnDeposito').attr('disabled', true)
        $('#btnLimpaDeposito').attr('disabled', true)
        $('.controleBlur').attr('disabled', false)
      }
    }
  );

  $("#btnDeposito").pesquisa_array(
    ["#txtDeposito"],
    ["CHAVE"],
    ["DESCRICAO"],
    `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["${filtroDeposito}"]}`,
    "Pesquisa Depósito",
    "DEPOSITO",
    () => {
      if ($('#txtDeposito').val()) {
        $('#txtDeposito').attr('disabled', true)
        $('#btnDeposito').attr('disabled', true)
        $('#btnLimpaDeposito').attr('disabled', true)
        $('.controleBlur').attr('disabled', false)
      }
    }
  );
  $('#btnLimpaDeposito').on('click', function () {
    $('#txtDeposito').val('');
  });

  $('#btn-Material').pesquisa_serverside(
    [`#txtMaterial`],
    ['CODIGO'],
    ['DESCRICAO'],
    '{"tabela": "material", "camposSelect": ["CODIGO", "DESCRICAO", "CODIGO2"], "where": null}', 'Pesquisa Material',
    async () => {
      await buscaLoteBarra()
    });

  $('#txtMaterial').autocompleta(
    1,
    'JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
    [],
    [],
    [],
    async () => {
      await buscaLoteBarra()
    });
  $('#btn-limpa-Material').on('click', function () {
    $('#txtMaterial').val('');

    $('#txtQualidade').autocompleta(
      1,
      'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
      [],
      [],
      [],
      async () => {
        await buscaLoteBarra()
      });

    $('#btn-Qualidade').pesquisa_array(
      ['#txtQualidade'],
      ['CODIGO'],
      ['DESCRICAO'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`,
      'Pesquisa Qualidade',
      'TABQUL',
      async () => {
        await buscaLoteBarra()
      });
  });

  $('#txtCor').autocompleta(
    1,
    'JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
    [],
    [],
    [],
    async () => {
      await buscaLoteBarra()
    });

  $('#btn-Cor').pesquisa_array(
    ['#txtCor'],
    ['COR'],
    ['DESCRICAO'],
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}`,
    'Pesquisa Cor',
    'CADCOR',
    async () => {
      await buscaLoteBarra()
    });
  $('#btn-limpa-Cor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#btn-Qualidade').pesquisa_array(
    ['#txtQualidade'],
    ['CODIGO'],
    ['DESCRICAO'],
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`,
    'Pesquisa Qualidade',
    'TABQUL',
    async () => {
      await buscaLoteBarra()
    });

  $('#txtQualidade').autocompleta(
    1,
    'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
    [],
    [],
    [],
    async () => {
      await buscaLoteBarra()
    });
  $('#btn-limpa-Qualidade').on('click', function () {
    $('#txtQualidade').val('');
  });

  $('#txtTonalidade').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE CHAVE", "ATIVO DESCRICAO"], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`);
  $('#btnTonalidade').pesquisa_array(['#txtTonalidade'], ['TONALIDADE'], ['ATIVO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'Pesquisa Tonalidade', 'MAT_ITEN');
  $('#btnLimpaTonalidade').on('click', function () {
    $('#txtTonalidade').val('');
  });

  $('#btnLimpaLote').on('click', function () {
    $('#txtLote').val('');
  });

  $('#txtQtde').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 6
  });

  $('#txtQtdeAux').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 6
  });

  async function buscaLoteBarra() {
    try {
      let lote = ''
      const codigo = pegaChave('#txtMaterial')
      const cor = pegaChave('#txtCor')
      const qualidade = pegaChave('#txtQualidade')

      if ($('#txtLote').val().includes('[')) {
        lote = pegaChave('#txtLote')
      } else {
        lote = $('#txtLote').val()
      }

      if (codigo && cor && qualidade && lote) {
        const pesquisa = {
          tabela: 'MAT_ITEN',
          camposSelect: ['LOTE_INTERNO', 'BARRA', 'DT_FAB', 'TONALIDADE'],
          where: [`CODIGO = '${codigo}' AND COR = '${cor}' AND QUALIDADE = '${qualidade}' AND LOTE = '${lote}'`]
        }
        const matIten = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (matIten.length > 0) {
          if (matIten[0].TONALIDADE) {
            insereValor('#txtTonalidade', matIten[0].TONALIDADE, 'S')
          } else {
            $('#txtTonalidade').attr('disabled', false)
            $('#btnTonalidade').attr('disabled', false)
            $('#btnLimpaTonalidade').attr('disabled', false)
          }
          if (matIten[0].DT_FAB) {
            $('#dtFabricacao').val(matIten[0].DT_FAB.split(' ')[0])
          } else {
            $('#dtFabricacao').attr('disabled', false)
          }
          if (matIten[0].LOTE_INTERNO) {
            $('#txtLoteInterno').val(matIten[0].LOTE_INTERNO)
          } else {
            $('#txtLoteInterno').attr('disabled', false)
            $('#btnLoteInterno').attr('disabled', false)
            $('#btnLimpaLoteInterno').attr('disabled', false)
          }
          if (matIten[0].BARRA) {
            $('#txtBarraManual').val(matIten[0].BARRA)
          } else {
            $('#txtBarraManual').attr('disabled', false)
            $('#btnBarraManual').attr('disabled', false)
            $('#btnLimpaBarraManual').attr('disabled', false)
          }
        } else {
          $('#txtTonalidade').val('')
          $('#txtBarraManual').val('')
          $('#dtFabricacao').val('')
          $('#btnLoteInterno').val('')
          $('.controleBlur2').attr('disabled', false)
        }

        $('.controleBlur3').attr('disabled', false)
        $('.controleBlur4').attr('disabled', false)
      }

    } catch (error) {

    }
  }

  $('#txtLote').on('blur', async function () {
    await buscaLoteBarra()
  })

  async function saidaCampoQualidade() {
    $('#btnLote').attr('disabled', false)
    $('#btnLote').pesquisa_array(
      ['#txtLote'],
      ['LOTE'],
      ['CODIGO'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO" ], "where": ["(LOTE <> '' OR LOTE IS NOT NULL) AND CODIGO = '${pegaChave('#txtMaterial')}' AND MAT_ITEN.COR = '${pegaChave('#txtCor')}' AND MAT_ITEN.QUALIDADE = '${pegaChave('#txtQualidade')}' AND MAT_ITEN.DEPOSITO='${pegaChave('#txtDeposito')}'"], "groupBy": ["LOTE", "CODIGO"]}`,
      'Pesquisa Lote',
      'MAT_ITEN',
      async () => {
        await buscaLoteBarra()
      });
    $('#btnLimpaLote').on('click', function () {
      $('#txtLote').val('')
    })
  }

  $('#txtMaterial').on('blur', async function () {
    $('#txtCor').unbind('autocompleta');
    $('#btn-Cor').off();
    $('#btn-Cor').unbind('pesquisa_array');

    $('#txtCor').autocompleta(
      1,
      `JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR CHAVE", "CADCOR.DESCRICAO DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`,
      [],
      [],
      [],
      async () => {
        await buscaLoteBarra()
      });

    $('#btn-Cor').pesquisa_array(
      ['#txtCor'],
      ['COR'],
      ['DESCRICAO'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`,
      'Pesquisa Cor',
      'CADCOR',
      async () => {
        await buscaLoteBarra()
      });

    $('#txtQualidade').unbind('autocompleta');
    $('#btn-Qualidade').off();
    $('#btn-Qualidade').unbind('pesquisa_array');

    $('#txtQualidade').autocompleta(
      1,
      'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}',
      [],
      [],
      [],
      async () => {
        await buscaLoteBarra()
        await saidaCampoQualidade()
      });

    $('#btn-Qualidade').pesquisa_array(
      ['#txtQualidade'],
      ['QUALIDADE'],
      ['DESCRICAO'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO" ], "leftjoin": [{ "tabela" : "TABQUL", "condicao" : "TABQUL.CODIGO = MAT_ITEN.QUALIDADE" }], "where": ["(MAT_ITEN.QUALIDADE <> '' OR MAT_ITEN.QUALIDADE IS NOT NULL) AND MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}' AND MAT_ITEN.DEPOSITO = '${pegaChave('#txtDeposito')}'"], "groupBy": ["MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO"]}`,
      'Pesquisa Qualidade',
      'TABQUL',
      async () => {
        await buscaLoteBarra()
        await saidaCampoQualidade()
      });

    $('#btnLote').attr('disabled', false)
    $('#btnLote').pesquisa_array(
      ['#txtLote'],
      ['LOTE'],
      ['CODIGO'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO" ], "where": ["(LOTE <> '' OR LOTE IS NOT NULL) AND CODIGO = '${$(this).attr('data-chave')}'"], "groupBy": ["LOTE", "CODIGO"]}`,
      'Pesquisa Lote',
      'MAT_ITEN',
      async () => {
        await buscaLoteBarra()
      });

    $('#txtQualidade').val('');
    if ($('#txtMaterial').val() !== '') {
      const codigo = pegaChave('#txtMaterial')
      const pesquisa = {
        tabela: 'MATERIAL',
        camposSelect: ['UNIDADE', 'UNI_AUX', 'RENDIMENTO'],
        where: [`CODIGO = '${codigo}'`]
      }
      const matIten = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      $('#txtUnidade').val(matIten[0].UNIDADE)
      $('#txtUnidadeAux').val(matIten[0].UNI_AUX)
      $('#txtRendimento').val(matIten[0].RENDIMENTO)
    }
  });

  let inputBarras = $('.barras');
  inputBarras.on('click', function () {
    inputBarras.get().forEach(function (ev) {
      let event = ev;
      event.checked = ev == this && this.checked;
    }, this);
  });

  $('#tabelaInventarioMaterial').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    autoWidth: false,
    destroy: true,
    lengthChange: true,
    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Todos']],
    columnDefs: [
      {
        "targets": [9, 10],
        "render": function (data) {
          return parseFloat(data).toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          })
        },
      },
      {
        "targets": [7, 8, 9, 10],
        "className": 'pr-4 text-right'
      }
    ],
  });

  const colunasInvisiveis = JSON.parse(
    localStorage.getItem("colunasInvisiveisRelatorios")
  );

  $("#tabelaInventarioMaterial_wrapper").prepend(
    '<button class="buttonColVis ml-1 mb-1" id="buttonColVis"><i class="fas fa-cogs"></i></button>'
  );

  $("#buttonColVis").on("click", async function (e) {
    e.preventDefault()
    $.LoadingOverlay("show");
    $("#modal-ColunasVisiveis").modal("show");
    $.LoadingOverlay("hide");
  });

  $("#buttonColVis").prop("title", "Configurar colunas");

  $("#tabelaInventarioMaterial")
    .DataTable()
    .columns()
    .every(function () {
      const colAtual = String(this.dataSrc());
      if (
        colunasInvisiveis.inventarioMaterial.indexOf(colAtual) != -1
      ) {
        this.visible(false);
      }
    });

  $("#checkBarra").attr("checked", true);
  $("#txtQtde").val(1);

  $('#btnAddCondicao').on('keypress', function () {
    $('#btnAddCondicao').trigger('click');
  });

  $('#btn-adicionar').on('keypress', function () {
    $('#btn-adicionar').trigger('click');
  });

  $('#txtSetor').on("focus", function () {
    let that = $(this);
    setTimeout(function () {
      that.select();
    }, 1)

  }).on('keydown', function (e) {
    if ((e.key == 'Tab') || (e.key == 'Enter')) {
      e.preventDefault();
      $('#txtBarra').focus();
      $('#txtBarra').click();
    }
  });

  $('#txtQtde').on("focus", function () {
    let that = $(this);
    setTimeout(function () {
      that.select();
    }, 1)

  }).on('keydown', function (e) {
    if ((e.key == 'Tab') || (e.key == 'Enter')) {
      e.preventDefault();
      $('#btn-adicionar').focus();
    }
  });

  $('#tipos').on('change', async function () {
    if ($('#checkManual').prop('checked')) {
      $('#barraPrincipal').addClass('d-none');
      $('#materialDivPrincipal').removeClass('d-none');
      $('#corPrincipal').removeClass('d-none');
      $('#qtdePrincipal').removeClass('d-none');
      $('#divLote').removeClass('d-none');
      $('#divQualidade').removeClass('d-none');
      $('#divUnidade').removeClass('d-none');
      $('#divUnidadeAux').removeClass('d-none');
      $('#divRendimento').removeClass('d-none');
      $('#divQtdeAux').removeClass('d-none');
      $('#btnAdd').removeClass('d-none');
      $('#divDtFabricacao').removeClass('d-none');
      $('#divBarra').removeClass('d-none');
      $('#divTonalidade').removeClass('d-none');
      $('#divLoteInterno').removeClass('d-none');
      $('#QualidadeInfoTour').removeClass('d-none');
    }
    if ($('#checkBarra').prop('checked')) {
      $('#barraPrincipal').removeClass('d-none');
      $('#materialDivPrincipal').addClass('d-none');
      $('#corPrincipal').addClass('d-none');
      $('#qtdePrincipal').addClass('d-none');
      $('#divLote').addClass('d-none');
      $('#divQualidade').addClass('d-none');
      $('#divUnidade').addClass('d-none');
      $('#divUnidadeAux').addClass('d-none');
      $('#divRendimento').addClass('d-none');
      $('#divQtdeAux').addClass('d-none');
      $('#btnAdd').addClass('d-none');
      $('#divDtFabricacao').addClass('d-none');
      $('#divBarra').addClass('d-none');
      $('#divTonalidade').addClass('d-none');
      $('#divLoteInterno').addClass('d-none');
      $('#QualidadeInfoTour').addClass('d-none');
    }
  });

  $('#txtQtdeAux').on('blur', function () {
    const qtdeAtual = $('#txtQtdeAux').val()
    const rendimento = $('#txtRendimento').val()
    if (qtdeAtual != '') {
      const qtdeNova = qtdeAtual * rendimento
      $('#txtQtde').val(TruncaDecimaisNova(6, qtdeNova))
    }
  })

  $('#btnGravar').on('click', async function () {
    try {
      $('#btnGravar').prop('disabled', true);
      $.LoadingOverlay("show");
      try {

        if ($('#txtSetor').val() == '') {
          return msgAlerta('Setor não informado ou inválido!');
        }

        if ($('#txtData').val() == '') {
          return msgAlerta('Data não informada ou inválida!');
        }

        if ($('#tabelaInventarioMaterial').DataTable().data().length === 0) {
          return msgAlerta('Nenhum item adicionado, impossível continuar!');
        }

        for (let i = 0; i < $('#tabelaGerarInventarioLoja').DataTable().rows().count(); i++) {
          const dados = $('#tabelaGerarInventarioLoja').DataTable().row(i).data();
          const dadosValidacao = dados[5];
          const saoIguais = dadosValidacao === 0
          if (saoIguais) {
            $('#tabelaGerarInventarioLoja').DataTable().row(i).data(dados).remove().draw(false);
          }
        }

        let objetoInventario = await preencheJson();

        const response = await requisicao('POST', '/sisplan/inventario/v1/inventariomat?', `IS_WEB=${true}`, JSON.stringify(objetoInventario), 30000);
        if (!response) {
          return;
        }

        if (response.status != 200) {
          const jsonInventario = await response.json();
          msgErro(jsonInventario.mensagem);
          return;
        }
        toastr.success(
          'Cadastro efetuado com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/inventarioMat`;
          },
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        await limpaCampos();
      } catch (error) {
        console.error(error);
      }
    } finally {
      $('#btnGravar').prop('disabled', false);
      $.LoadingOverlay("hide");
    }

    await deletaArquivo('JsonInventarioMaterial');
  });

  async function limpaCampos() {
    $('#tabelaInventarioMaterial').DataTable().clear().draw(false);
    $('#txtQualidade').val('');
    $('#txtDeposito').val('');
    $('#txtSetor').val('');
    $('#txtQtde').val(1);
    $('#txtBarra').val('');
    $('#txtMaterial').val('');
    $('#txtCor').val('');

    $('#txtTonalidade').val('');
    $('#txtLoteInterno').val('');
    await setarDataAtual('dtFabricacao');
    $('#txtLote').val('');
    $('#txtQtdeAux').val('');
    $('#txtUnidadeAux').val('');
    $('#txtRendimento').val('');
    $('#txtQtde').val('');
    $('#txtUnidade').val('');
    if ($('#checkManual').prop('checked')) {
      $("#checkBarra").attr("checked", true);
    }
    if ($('#checkBarraPorLote').prop('checked')) {
      $("#checkBarraPorLote").prop("checked", false);
    }
    if ($('#checkControlaPeca').prop('checked')) {
      $("#checkControlaPeca").prop("checked", false);
    }
  }

  $('#modalCadPeso').on('shown.bs.modal', function () {
    $('#txtPesoManual').val('');
    $('#txtPesoManual').focus();
  });

  $('#btnCancelar').on('click', async function () {
    msgAlerta('Deseja realmente cancelar os itens passados?', cancelaItens);
    await deletaArquivo('JsonInventarioMaterial');
  });

  async function cancelaItens() {
    $('#txtSetor').attr('disabled', false)
    $('#btnSetor').attr('disabled', false)
    $('#btnLimpaSetor').attr('disabled', false)

    $('#txtDeposito').attr('disabled', false)
    $('#btnDeposito').attr('disabled', false)
    $('#btnLimpaDeposito').attr('disabled', false)

    $('.controleBlur').attr('disabled', true)
    $('.controleBlur2').attr('disabled', true)
    $('.controleBlur3').attr('disabled', true)

    setarDataAtual('txtData')
    $('#txtSetor').val('')
    $('#txtDeposito').val('')
    $('#txtMaterial').val('')
    $('#txtCor').val('')
    $('#txtQualidade').val('')
    $('#txtLote').val('')
    $('#dtFabricacao').val('')
    $('#txtTonalidade').val('')
    $('#txtLoteInterno').val('')
    $('#txtBarraManual').val('')
    $('#txtQtdeAux').val(0)
    $('#txtUnidadeAux').val('')
    $('#txtRendimento').val(0)
    $('#txtQtde').val(0)
    $('#txtUnidade').val('')

    $('#tabelaInventarioMaterial').DataTable().clear().draw(false);

    const data = new Date();
    await rotinaGeraLog('INVENTARIO MATERIAL', data.toLocaleDateString(), 'INVENTARIO CANCELADO MATERIAL- BOTAO CANCELAR SELECIONADO', 'Exclusão');
  }

  $('#btn-adicionar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#txtQualidade').val() === '') {
          msgAlerta('Qualidade inválida ou não informada!');
          return;
        }
        if ($('#txtSetor').val() === '') {
          msgAlerta('Setor não informado, verifique!');
          return;
        }
        if ($('#txtDeposito').val() === '') {
          msgAlerta('Depósito inválido ou não informado!');
          return;
        }
        if ($('#txtLote').val() === '') {
          msgAlerta('lote não informado, verifique!');
          return;
        }
        if ($('#txtMaterial').val() != '') {
          if ($('#txtCor').val() != '') {
            if ($('#txtQtde').val() != '') {
              if ($('#txtQtde').val() == 0) {
                msgAlerta('Quantidade não informada ou igual a zero. Impossível Continuar!');
                return;
              }

              const bExiste = await verificaInventarioExistente()
              if (bExiste) {
                throw msgAlerta('Item já existe em inventário para esta data, verifique!')
              }

              const url = '/sisplan/funcoes/v1/pesquisa?';

              response = await requisicao('GET', url, `JSON={ "tabela":"MATERIAL", "camposSelect":["MATERIAL.CODIGO", "MATERIAL.DESCRICAO AS DESCRICAO", "MATERIAL.CODIGO2", "MATERIAL.UNIDADE", "MATERIAL.POSSE"], 
                  "where":["1=1 AND MATERIAL.CODIGO = ${pegaChave('#txtMaterial')}"]}`, null);

              if (response.status != 200) {
                msgErro(jsonInventario.mensagem);
                return;
              }

              let lote = ''
              if ($('#txtLote').val().includes('[')) {
                lote = pegaChave('#txtLote')
              } else {
                lote = $('#txtLote').val()
              }

              let jsonInventario = await response.json();

              let arrayLinhaNova = []
              arrayLinhaNova.CODIGO = pegaChave('#txtMaterial')
              arrayLinhaNova.DESCRICAO = pegaDescricao('#txtMaterial')
              arrayLinhaNova.CODIGO2 = jsonInventario.RESULT[0][0].CODIGO2 ? jsonInventario.RESULT[0][0].CODIGO2 : ''
              arrayLinhaNova.UNIDADE = jsonInventario.RESULT[0][0].UNIDADE ? jsonInventario.RESULT[0][0].UNIDADE : ''
              arrayLinhaNova.COR = pegaChave('#txtCor')
              arrayLinhaNova.LOTE = lote
              arrayLinhaNova.LOTE_INTERNO = $('#txtLoteInterno').val()
              arrayLinhaNova.QTDE = TruncaDecimaisNova(6, $('#txtQtde').val())
              arrayLinhaNova.QTDE_ORIG = 0
              arrayLinhaNova.PRECO_MED = 0
              arrayLinhaNova.DEPOSITO = pegaChave('#txtDeposito')
              arrayLinhaNova.DESC_DEPOSITO = pegaDescricao('#txtDeposito')
              arrayLinhaNova.QUALIDADE = pegaChave('#txtQualidade')
              arrayLinhaNova.DESC_QUALIDADE = pegaDescricao('#txtQualidade')
              arrayLinhaNova.UNI_AUX = TruncaDecimaisNova(6, $('#txtUnidadeAux').val())
              arrayLinhaNova.RENDIMENTO = $('#txtRendimento').val()
              arrayLinhaNova.TONALIDADE = pegaChave('#txtTonalidade')
              arrayLinhaNova.DT_FAB = $('#dtFabricacao').val() ? $('#dtFabricacao').val() : $('#txtData').val()
              arrayLinhaNova.BARRA = $('#txtBarraManual').val()

              jsonInventario.RESULT[0][0].POSSE == 0 ? arrayLinhaNova.POSSE = '0 - Não informado' :
                jsonInventario.RESULT[0][0].POSSE == 1 ? arrayLinhaNova.POSSE = '1 - Mercadoria de propriedade do informante e em seu poder' :
                  jsonInventario.RESULT[0][0].POSSE == 2 ? arrayLinhaNova.POSSE = '2 - Mercadoria de propriedade do informante em poder de terceiros' :
                    jsonInventario.RESULT[0][0].POSSE == 3 ? arrayLinhaNova.POSSE = '3 - Mercadoria de propriedade de terceiros em poder do informante' : '';

              await preencheObjetoLinhaNova(arrayLinhaNova);
              $('#txtMaterial').val('');
              $('#txtQualidade').val('');
              $('#txtCor').val('');
              $('#txtQtde').val(1);
              $('#txtTonalidade').val('');
              $('#txtLoteInterno').val('');
              $('#txtLote').val('');
              $('#txtQtdeAux').val('');
              $('#txtUnidade').val('');
              $('#txtUnidadeAux').val('');
              $('#txtRendimento').val(0);
              $('#txtBarraManual').val('');
              await setarDataAtual('dtFabricacao');

              $('.controleBlur2').attr('disabled', true)
              $('.controleBlur3').attr('disabled', true)
            } else {
              msgAlerta('Quantidade não informada ou igual a zero. Impossível Continuar!');
            }
          } else {
            msgAlerta('Cor inexistente ou não informada. Impossível continuar!');
          }
        } else {
          msgAlerta('Material inexistente ou não informado. Impossível continuar!');
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }

    const jsonarquivo = montaJsonArquivo();
    await salvaArquivo('JsonInventarioMaterial', jsonarquivo);
  });

  async function validaLoteDepositoMaterial(barra, codigo, deposito) {
    try {
      const url = '/sisplan/funcoes/v1/pesquisa?';
      const barraPorLoteCheck = $('#checkBarraPorLote').is(':checked');
      const responseLote = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["LOTE"], "where":["LOTE = '${barra}'"]}`, null);

      if (!responseLote) {
        return true;
      }

      const jsonInventarioLote = await responseLote.json();
      if (responseLote.status != 200) {
        msgErro(jsonInventarioLote.mensagem);
        return true;
      }

      if (jsonInventarioLote.RESULT[0].length > 0 && (!barraPorLoteCheck)) {
        msgAlerta('Marque a opção Barra por Lote para fazer o inventário pelo Lote.');
        return true;
      }

      const responseCodigo = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["CODIGO"], "where":["CODIGO = '${barra}'"]}`, null);

      if (!responseCodigo) {
        return true;
      }

      const jsonInventarioCodigo = await responseCodigo.json();
      if (responseCodigo.status != 200) {
        msgErro(jsonInventarioCodigo.mensagem);
        return true;
      }

      if (jsonInventarioCodigo.RESULT[0].length > 0) {
        msgAlerta('Material Existente! Use a Opção Tipo Manual Para Fazer o Inventário Pelo Código de Material.');
        $('#txtBarra').val('');
        return true;
      }

      const responseBarraLote = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["BARRA", "LOTE"], "where":["1=1 ${codigo}"]}`, null);

      if (!responseBarraLote) {
        return true;
      }

      const jsonInventarioBarraLote = await responseBarraLote.json();
      if (responseBarraLote.status != 200) {
        msgErro(jsonInventarioBarraLote.mensagem);
        return true;
      }

      if (jsonInventarioBarraLote.RESULT[0].length == 0) {
        msgAlerta('Barra/Lote do Material Inexistente!');
        return true;
      }

      const responseDeposito = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["DEPOSITO", "BARRA", "LOTE"], "where":["1=1 ${codigo} ${deposito}"]}`, null);

      if (!responseDeposito) {
        return true;
      }

      const jsonInventarioDeposito = await responseDeposito.json();
      if (responseDeposito.status != 200) {
        msgErro(jsonInventarioDeposito.mensagem);
        return true;
      }

      if (jsonInventarioDeposito.RESULT[0].length == 0) {
        msgAlerta('Material não está no depósito que está sendo inventariado. Impossível continuar!');
        return true;
      }
      return false;

    } catch (error) {
      msgErro('Erro ao validar Lote/Depósito/Material.');
      console.error(error);
    }
  }

  async function verificaInventarioExistente(bBarra = false) {
    try {
      $.LoadingOverlay('show')
      let where = ''
      if (bBarra) {
        where += ` AND DT_MES = '${$('#txtData').val()}'`
        where += ` AND LOTE = '${$('#txtBarra').val()}'`
        where += ` AND DEPOSITO = '${pegaChave('#txtDeposito')}'`
      } else {
        where += ` AND DT_MES = '${$('#txtData').val()}'`
        where += ` AND DEPOSITO = '${pegaChave('#txtDeposito')}'`
        where += ` AND CODIGO = '${pegaChave('#txtMaterial')}'`
        where += ` AND COR = '${pegaChave('#txtCor')}'`
        where += ` AND QUALIDADE = '${pegaChave('#txtQualidade')}'`
        where += ` AND LOTE = '${$('#txtLote').val().includes('[') ? pegaChave('#txtLote') : $('#txtLote').val()}'`
      }

      const response = await requisicao(
        'GET',
        '/sisplan/funcoes/v1/pesquisa?',
        `JSON={ "tabela":"INVENTARIO", "camposSelect":["CODIGO", "COR", "QUALIDADE", "LOTE", "DT_MES", "DEPOSITO"], "where":["1=1 ${where}"]}`,
        null);

      if (response.status !== 200) {
        throw msgAlerta('Não foi possível realizar a busca pelo item, verifique!')
      }

      const jsonStr = await response.json()
      if (jsonStr.RESULT[0].length) {
        return true
      } else {
        return false
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#txtBarra').on('blur', async function () {
    if (!$('#txtBarra').val()) {
      return
    }
    if ($('#txtBarra').val() === '000000') {
      throw msgAlerta('Barra não pode ser igual a 000000, verifique!')
    }
    if (!$('#txtDeposito').val()) {
      throw msgAlerta('Depósito inválido ou não informado');
    }

    const bExiste = await verificaInventarioExistente(true)
    if (bExiste) {
      $('#txtBarra').val('')
      throw msgAlerta('Item já existe em inventário para esta data, verifique!')
    }

    const barra = $('#txtBarra').val().trim();
    $('#ultimoCodigo').val(barra);

    try {
      $.LoadingOverlay('show');
      const deposito = `AND MAT_ITEN.DEPOSITO = '${pegaChave(('#txtDeposito'))}'`;
      const codigo = $('#checkBarraPorLote').prop('checked') ? `AND LOTE = '${barra}'` : `AND BARRA = '${barra}'`;

      const naoPassouNaValidacao = await validaLoteDepositoMaterial(barra, codigo, deposito);
      if (naoPassouNaValidacao) {
        return;
      }

      const response = await requisicao(
        'GET',
        '/sisplan/funcoes/v1/pesquisa?', `JSON={ ` +
        `"tabela":"MAT_ITEN", ` +
        `"camposSelect":["MAT_ITEN.CODIGO",` +
        `"MATERIAL.DESCRICAO AS DESCRICAO", ` +
        `"MATERIAL.CODIGO2", ` +
        `"MATERIAL.UNIDADE",` +
        `"MAT_ITEN.COR",` +
        `"MAT_ITEN.LOTE", ` +
        `"MAT_ITEN.LOTE_INTERNO", ` +
        `"MAT_ITEN.BARRA", ` +
        `"MATERIAL.POSSE", ` +
        `"MAT_ITEN.DEPOSITO", ` +
        `"DEPOSITO.DESCRICAO DESC_DEPOSITO", ` +
        `"MAT_ITEN.QUALIDADE",` +
        `"TABQUL.DESCRICAO DESC_QUALIDADE",` +
        `"MAT_ITEN.QTDE",` +
        `"MAT_ITEN.QTDE_ORIG", ` +
        `"MAT_ITEN.PRECO_MED",` +
        `"MATERIAL.UNI_AUX",` +
        `"MATERIAL.RENDIMENTO",` +
        `"MAT_ITEN.TONALIDADE",` +
        `"MAT_ITEN.BARRA",` +
        `"MAT_ITEN.DT_FAB"], ` +
        `"leftjoin": [` +
        `{ "tabela": "MATERIAL", "condicao": "MATERIAL.CODIGO = MAT_ITEN.CODIGO" }, ` +
        `{ "tabela": "TABQUL", "condicao": "TABQUL.CODIGO = MAT_ITEN.QUALIDADE" }, ` +
      `{ "tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = MAT_ITEN.DEPOSITO" }],
        "where": ["1=1 ${codigo} ${deposito}"]}`,
        null);

      if (!response) {
        return;
      }
      const jsonInventario = await response.json();
      if (response.status != 200) {
        msgErro(jsonInventario.mensagem);
        return;
      }

      if (jsonInventario.RESULT[0].length == 0) {
        msgAlerta('Material não encontrado!')
        return;
      }

      jsonInventario.RESULT[0][0].POSSE == 0 ? jsonInventario.RESULT[0][0].POSSE = '0 - Não informado' :
        jsonInventario.RESULT[0][0].POSSE == 1 ? jsonInventario.RESULT[0][0].POSSE = '1 - Mercadoria de propriedade do informante e em seu poder' :
          jsonInventario.RESULT[0][0].POSSE == 2 ? jsonInventario.RESULT[0][0].POSSE = '2 - Mercadoria de propriedade do informante em poder de terceiros' :
            jsonInventario.RESULT[0][0].POSSE == 3 ? jsonInventario.RESULT[0][0].POSSE = '3 - Mercadoria de propriedade de terceiros em poder do informante' : '';

      const rotinaPreencheObjeto = async (objeto) => {
        const jsonFormatado = objeto;
        await preencheObjetoLinhaNova(jsonFormatado);
        $('#txtBarra').val('');
        $('#txtBarra').focus();
      }

      if (jsonInventario.RESULT[0][0].QTDE == 0 || jsonInventario.RESULT[0][0].QTDE == null || jsonInventario.RESULT[0][0].QTDE == undefined) {
        $('#modalCadPeso').modal('show');
        abrirModalPeso(jsonInventario.RESULT[0][0], rotinaPreencheObjeto);
        return;
      }

      await rotinaPreencheObjeto(jsonInventario.RESULT[0][0]);

    } catch (error) {
      msgErro('Erro ao buscar item.');
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
    const jsonarquivo = montaJsonArquivo();
    await salvaArquivo('JsonInventarioMaterial', jsonarquivo);
  })

  function abrirModalPeso(objetoAtual, callback) {
    $('#txtQtdeAuxModal').val(0)
    $('#txtUnidadeAuxModal').val(objetoAtual.UNI_AUX)
    $('#txtRendimentoModal').val(objetoAtual.RENDIMENTO)
    $('#txtPesoManual').val(objetoAtual.QTDE)
    $('#txtUnidadeModal').val(objetoAtual.UNIDADE)
    $('#btn_confirmar_peso').unbind('click');
    $('#btn_confirmar_peso').on('click', async function () {
      const peso = $('#txtPesoManual').val();
      if (peso == '') {
        peso = 0;
      }
      objetoAtual.QTDE = peso;
      if (callback) {
        $('#modalCadPeso').modal('hide');
        await callback(objetoAtual);
      }
    });
  }

  $('#txtQtdeAuxModal').on('blur', function () {
    $('#txtPesoManual').val(TruncaDecimaisNova(2, $(this).val() * $('#txtRendimentoModal').val()))
  })

  async function preencheObjetoLinhaNova(objeto) {
    try {
      const qtdeLinhas = $('#tabelaInventarioMaterial').DataTable().rows().count();
      const qtde = $('#txtQtde').val()

      if ($('#checkBarra').prop('checked')) {
        barraLote = objeto.LOTE
        sLoteValidacao = objeto.LOTE;

        const valor = objeto.PRECO_MED * objeto.QTDE;
        const novaLinha = [
          objeto.CODIGO,
          objeto.DESCRICAO,
          objeto.CODIGO2,
          objeto.UNIDADE,
          objeto.COR,
          barraLote,
          objeto.LOTE_INTERNO,
          objeto.QTDE,
          objeto.QTDE_ORIG,
          objeto.PRECO_MED,
          valor,
          objeto.DEPOSITO,
          objeto.DESC_DEPOSITO,
          objeto.QUALIDADE,
          objeto.DESC_QUALIDADE,
          objeto.POSSE,
          objeto.UNI_AUX,
          objeto.RENDIMENTO,
          objeto.TONALIDADE,
          objeto.DT_FAB,
          objeto.BARRA,
        ];

        if (qtdeLinhas > 0) {
          for (let i = 0; i < $('#tabelaInventarioMaterial').DataTable().rows().count(); i++) {
            const dados = $('#tabelaInventarioMaterial').DataTable().row(i).data();
            const loteTabela = dados[5];
            const saoIguais = loteTabela == sLoteValidacao
            if (saoIguais) {
              msgAlerta('Lote já cadastrado. Favor verifique!');
              return;
            }
          }
          $('#tabelaInventarioMaterial').DataTable().row.add(novaLinha).draw(false);
          return;
        }
        $('#tabelaInventarioMaterial').DataTable().row.add(novaLinha).draw(false);
      }

      if ($('#checkManual').prop('checked')) {
        const valor = objeto.PRECO_MED * qtde
        const novaLinha = [
          objeto.CODIGO,
          objeto.DESCRICAO,
          objeto.CODIGO2,
          objeto.UNIDADE ? objeto.UNIDADE : $('#txtUnidade').val(),
          objeto.COR,
          objeto.LOTE ? objeto.LOTE : $('#txtLote').val(),
          objeto.LOTE_INTERNO ? objeto.LOTE_INTERNO : $('#txtLoteInterno').val(),
          qtde,
          objeto.QTDE_ORIG,
          objeto.PRECO_MED,
          valor,
          objeto.DEPOSITO,
          objeto.DESC_DEPOSITO,
          objeto.QUALIDADE ? objeto.QUALIDADE : pegaChave('#txtQualidade'),
          objeto.DESC_QUALIDADE,
          objeto.POSSE,
          objeto.UNI_AUX ? objeto.UNI_AUX : $('#txtUnidadeAux').val(),
          objeto.RENDIMENTO,
          objeto.TONALIDADE ? objeto.TONALIDADE : pegaChave('#txtTonalidade'),
          objeto.DT_FAB,
          objeto.BARRA
        ];

        if (qtdeLinhas > 0) {
          for (let i = 0; i < $('#tabelaInventarioMaterial').DataTable().rows().count(); i++) {
            let lote = ''
            const codigo = pegaChave('#txtMaterial')
            const descricao = pegaDescricao('#txtMaterial')
            const cor = pegaChave('#txtCor')
            const qualidade = pegaChave('#txtQualidade')
            let dados = $('#tabelaInventarioMaterial').DataTable().row(i).data();

            if ($('#txtLote').val().includes('[')) {
              lote = pegaChave('#txtLote')
            } else {
              lote = $('#txtLote').val()
            }

            const codigoTabela = dados[0];
            const corTabela = dados[4];
            const qualidadeTabela = dados[13];
            const loteTabela = dados[5];
            const qtdeTabela = Number(dados[7]);

            const saoIguais = loteTabela == lote && codigoTabela == codigo && corTabela === cor && qualidadeTabela == qualidade
            if (saoIguais) {
              await msgAguardaConfirmacao(`Material: ${codigo} - ${descricao}, Cor: ${cor}, Lote: ${lote}, Qualidade: ${qualidade} já adicionado. Deseja Atualizar as quantidades?`, () => {
                const qtdeAntiga = Number(novaLinha[7])
                
                dados[7] = (qtdeTabela + qtdeAntiga).toFixed(6)
                $('#tabelaInventarioMaterial').DataTable().row(i).data(dados).draw()
              }, () => {
                return
              })

              return
            }
          }
          $('#tabelaInventarioMaterial').DataTable().row.add(novaLinha).draw(false);
          return;
        }
        $('#tabelaInventarioMaterial').DataTable().row.add(novaLinha).draw(false);

      }
    } catch (error) {
      msgErro('Erro ao retornar a linha.');
    }
  }

  async function preencheJson() {
    let jsonInventario = []

    for (let i = 0; i < $('#tabelaInventarioMaterial').DataTable().rows().count(); i++) {
      let objetoInventario = {}
      const dados = $('#tabelaInventarioMaterial').DataTable().row(i).data();

      objetoInventario.CODIGO = dados[0];
      objetoInventario.COR = dados[4];
      objetoInventario.CODIGO2 = dados[2];
      objetoInventario.DEPOSITO = dados[11];
      objetoInventario.DESCRICAO = dados[1];
      objetoInventario.DT_MES = $('#txtData').val() != '' ? `${$('#txtData').val()}T00:00:00Z` : `1899-01-01T00:00:00Z`;
      objetoInventario.UNIDADE = dados[3];
      objetoInventario.LOTE = dados[5];
      objetoInventario.CODSETOR = pegaChave($('#txtSetor').val());
      objetoInventario.POSSE = dados[15].substr(0, 1);
      objetoInventario.QUALIDADE = dados[13];
      objetoInventario.PRECO = dados[9];
      objetoInventario.QTDE = dados[7];
      objetoInventario.VALOR = dados[9];
      objetoInventario.GRUPO = (await buscaValor("MATERIAL", "GRUPO", "CODIGO", dados[0])).GRUPO;
      objetoInventario.SUBGRUPO = (await buscaValor("MATERIAL", "SUB_GRUPO", "CODIGO", dados[0])).SUB_GRUPO;
      objetoInventario.LINHA = (await buscaValor("MATERIAL", "LINHA", "CODIGO", dados[0])).LINHA;
      objetoInventario.LOTE_INTERNO = dados[6];
      objetoInventario.TONALIDADE = dados[18]
      objetoInventario.DT_FAB = dados[19];
      objetoInventario.BARRA = dados[20]

      jsonInventario.push(objetoInventario);
    }

    const retorno = {
      Inventarios: jsonInventario
    }
    return retorno;
  }

  try {
    const response = await carregaArquivo('JsonInventarioMaterial');
    if (response.status === 200) {
      const jsonStr = await response.json();
      $('#txtSetor').attr('disabled', true)
      $('#btnSetor').attr('disabled', true)
      $('#btnLimpaSetor').attr('disabled', true)

      $('#txtDeposito').attr('disabled', true)
      $('#btnDeposito').attr('disabled', true)
      $('#btnLimpaDeposito').attr('disabled', true)

      $('.controleBlur').attr('disabled', false)
      $('.controleBlur2').attr('disabled', false)
      $('.controleBlur3').attr('disabled', false)
      insereValor("#txtQualidade", jsonStr.qualidade.split("] - ")[0].substr(1), jsonStr.qualidade.split("] - ")[1]);
      insereValor("#txtData", jsonStr.data);
      insereValor("#txtDeposito", jsonStr.deposito.split("] - ")[0].substr(1), jsonStr.deposito.split("] - ")[1]);
      insereValor("#txtSetor", jsonStr.setor.split("] - ")[0].substr(1), jsonStr.setor.split("] - ")[1]);
      jsonStr.itens.forEach((item) => {
        $("#tabelaInventarioMaterial")
          .DataTable()
          .row.add([
            item.codigo,
            item.descricao,
            item.codigo2,
            item.unidade,
            item.cor,
            item.lote,
            item.lote_interno,
            item.qtde,
            item.qtde_orig,
            item.preco,
            item.valor,
            item.deposito,
            item.desc_deposito,
            item.qualidade,
            item.desc_qualidade,
            item.posse,
            item.uni_aux,
            item.rendimento,
            item.tonalidade,
            item.dt_fab,
            item.barra,
          ])
          .draw(false);
      });


      msgAlerta("Carregado dados não salvos, verifique.");
    }
  } catch (error) {
    console.log(error);
  }

  function montaJsonItens() {
    const itensDataTable = $("#tabelaInventarioMaterial").DataTable().data().toArray();
    const itens = itensDataTable.map((itemDT) => {
      const item = {
        codigo: itemDT[0],
        descricao: itemDT[1],
        codigo2: itemDT[2],
        unidade: itemDT[3],
        cor: itemDT[4],
        lote: itemDT[5],
        lote_interno: itemDT[6],
        qtde: itemDT[7],
        qtde_orig: itemDT[8],
        preco: itemDT[9],
        valor: itemDT[10],
        deposito: itemDT[11],
        desc_deposito: itemDT[12],
        qualidade: itemDT[13],
        desc_qualidade: itemDT[14],
        posse: itemDT[15],
        uni_aux: itemDT[16],
        rendimento: itemDT[17],
        tonalidade: itemDT[18],
        dt_fab: itemDT[19],
        barra: itemDT[20],
      };
      return item;
    });
    return itens;
  }

  function montaJsonArquivo() {
    const importacao = {
      qualidade: $("#txtQualidade").val(),
      data: $("#txtData").val(),
      deposito: $("#txtDeposito").val(),
      setor: $("#txtSetor").val(),
      itens: montaJsonItens(),
    };
    return importacao;
  }
});
