$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#campostour',
                popover: {
                    title: 'Dados Gerais',
                    description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                    position: 'top'
                }
            },
            {
                element: '#txtCodigo',
                popover: {
                    title: 'Código',
                    description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                    position: 'top'
                }
            },
            {
                element: '#txtDescricao',
                popover: {
                    title: 'Descrição',
                    description: 'Neste campo adicionamos a descrição para o grupo de material.',
                    position: 'top'
                }
            },
            {
                element: '#selectTipo',
                popover: {
                    title: 'Tipo',
                    description: 'Aqui, selecionamos qual será o tipo do grupo de material.',
                    position: 'top'
                }
            },
            {
                element: '#utilizaTinturaria',
                popover: {
                    title: 'Utiliza Tinturaria',
                    description: 'Aqui definimos se o material é de entrada, saída ou ambos.',
                    position: 'top'
                }
            },
            {
                element: '#utilizaTingimento',
                popover: {
                    title: 'Utiliza tingimento',
                    description: 'Aqui definimos qual tipo de tingimento para o grupo.',
                    position: 'top'
                }
            },
            {
                element: '#opcoes',
                popover: {
                    title: 'Opções',
                    description: 'Neste campo, podemos selecionar algumas opções para este grupo de material.',
                    position: 'top'
                }
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar o grupo.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('#txtCodigo').prop('disabled', true);

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let grupo = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/grupomaterial`;
    });

    $(document).ready(async function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                }
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        if (grupo != '' && grupo != 'create') {
            carregaDados(grupo);
        }

        async function carregaDados(grupo) {
            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                            "tabela":"grupo_ma", 
                            "camposSelect":["codigo", "descricao", "desp", "inventario", "tipo", "tipo_mat",
                            "permitevenda", "cria_lote", "explosao_ficha", "cons_malha_av", "util_ting",
                            "atualiza_custo", "gera_of_insumo", "permitedesdobrarvend"], 
                            "where": ["codigo = '${grupo}'"]}`, null);
                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    };

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#selectTipo').val(jsonStr.RESULT[0][0].TIPO);

                    jsonStr.RESULT[0][0].TIPO_MAT == '0' ? $('#radioMatSaida').prop('checked', true)
                        : (jsonStr.RESULT[0][0].TIPO_MAT == '1' ? $('#radioMatEntrada').prop('checked', true)
                            : $('#radioAmbos').prop('checked', true))

                    jsonStr.RESULT[0][0].UTIL_TING == 'TIN' ? $('#radioTinturaria').prop('checked', true)
                        : (jsonStr.RESULT[0][0].UTIL_TING == 'INT' ? $('#radioIntermediario').prop('checked', true)
                            : (jsonStr.RESULT[0][0].UTIL_TING == 'TEC' ? $('#radioTecelagem').prop('checked', true)
                                : $('#radioCompras').prop('checked', true)))

                    jsonStr.RESULT[0][0].DESP == 'S' ? $('#checkControlaDesperdicio').prop('checked', true) : $('#checkControlaDesperdicio').prop('checked', false);
                    jsonStr.RESULT[0][0].INVENTARIO == 'S' ? $('#checkGeraInventario').prop('checked', true) : $('#checkGeraInventario').prop('checked', false);
                    jsonStr.RESULT[0][0].PERMITEVENDA == 'S' ? $('#checkPermiteVenda').prop('checked', true) : $('#checkPermiteVenda').prop('checked', false);
                    jsonStr.RESULT[0][0].PERMITEDESDOBRARVEND == 'S' ? $('#checkPermiteDesdobrarVenda').prop('checked', true) : $('#checkPermiteDesdobrarVenda').prop('checked', false);
                    jsonStr.RESULT[0][0].CRIA_LOTE == 'S' ? $('#checkCriaLote').prop('checked', true) : $('#checkCriaLote').prop('checked', false);
                    jsonStr.RESULT[0][0].EXPLOSAO_FICHA == 'S' ? $('#checkExplosao').prop('checked', true) : $('#checkExplosao').prop('checked', false);
                    jsonStr.RESULT[0][0].CONS_MALHA_AV == 'S' ? $('#checkConsMalha').prop('checked', true) : $('#checkConsMalha').prop('checked', false);
                    jsonStr.RESULT[0][0].ATUALIZA_CUSTO == 'S' ? $('#checkAtualizar').prop('checked', true) : $('#checkAtualizar').prop('checked', false);
                    jsonStr.RESULT[0][0].GERA_OF_INSUMO == 'S' ? $('#checkConsOf').prop('checked', true) : $('#checkConsOf').prop('checked', false);

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do preço: ${error}`);
                };
            } finally {
                $.LoadingOverlay('hide');
            }
        };

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $("#btnGravar").click(

        async function () {
            try {
                let validator = $("#msform").validate();
                validator.form();
                let erros = 0;
                erros = validator.numberOfInvalids();

                if (erros == 0) {
                    $.LoadingOverlay("show");

                    grupo = {};

                    grupo.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('grupo_ma', 'grupo_ma', 'CODIGO', 3) : $('#txtCodigo').val();
                    grupo.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    grupo.TIPO = $('#selectTipo').val();

                    grupo.TIPO_MAT = $("#radioMatSaida").is(":checked") ? $("#radioMatSaida").val()
                        : ($("#radioMatEntrada").is(":checked") ? $("#radioMatEntrada").val()
                            : $("#radioAmbos").val());

                    grupo.UTIL_TING = $("#radioTinturaria").is(":checked") ? $("#radioTinturaria").val()
                        : ($("#radioIntermediario").is(":checked") ? $("#radioIntermediario").val()
                            : ($("#radioTecelagem").is(":checked") ? $("#radioTecelagem").val()
                                : $("#radioCompras").val()));

                    grupo.DESP = $("#checkControlaDesperdicio").is(":checked") ? "S" : "N";
                    grupo.INVENTARIO = $("#checkGeraInventario").is(":checked") ? "S" : "N";
                    grupo.PERMITEVENDA = $("#checkPermiteVenda").is(":checked") ? "S" : "N";
                    grupo.PERMITEDESDOBRARVENDA = $('#checkPermiteDesdobrarVenda').is(':checked') ? 'S' : 'N';
                    grupo.CRIA_LOTE = $("#checkCriaLote").is(":checked") ? "S" : "N";
                    grupo.EXPLOSAO_FICHA = $("#checkExplosao").is(":checked") ? "S" : "N";
                    grupo.CONS_MALHA_AV = $("#checkConsMalha").is(":checked") ? "S" : "N";
                    grupo.ATUALIZA_CUSTO = $("#checkAtualizar").is(":checked") ? "S" : "N";
                    grupo.GERA_OF_INSUMO = $("#checkConsOf").is(":checked") ? "S" : "N";

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/grupomaterial?', `JSON=${encodeURIComponent(JSON.stringify(grupo))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Grupo Material: ${grupo.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/grupomaterial`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                };

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados do grupo: ${error}`);
            }
        });
});