$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoTipo',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma cotação de frete.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para imprimir os registros filtrados.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaCotacao',
                popover: {
                    title: 'Tabela Cotações',
                    description: 'Aqui estão os dados das cotações de frete cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    componenteFiltro('cliente', true, true)
    componenteFiltro('transportadora', true, true)
    componenteFiltro('pedido', true, true)

    const permissaoUsuarioLogado = await permissaoAcessos("FRETECOTA");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });


    function retornaBotaoOpcoes(data) {
        const retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Finalizar Cotação" id="btn-finalizar">Finalizar Cotação</button>  ' +
            `    <button id="btn-imprimirIndividual" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelFreteCotaIndividual.FR3"' : ''} class="dropdown-item">Imprimir</button>` +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    $('#btnConsultar').on('click', async function () {
        await consultaCotacao(true);
        $('#modal-filtros').modal('hide');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtTipo').val('');
        $('#rdTodos').prop('checked', true);
    });

    async function retornaFiltros() {
        const filtros = `DATADE=${$('#txtDataDe').val()}` +
            `&DATAATE=${$('#txtDataAte').val()}` +
            `&TIPONOTA=${$('.rdTipoNota:checked').val() == '0' ? '' : $('.rdTipoNota:checked').val() == '1' ? 'SAIDA' : 'ENTRADA'}` +
            `&SITUACAO=${$('.rdSituacaoOrcamento:checked').val() == '0' ? '' : $('.rdSituacaoOrcamento:checked').val()}` +
            `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
            `&TRANSP=${await formataListas($('#txtTransportadora').val().toString())}` +
            `&PEDIDO=${await formataListas($('#txtPedido').val().toString())}` +
            `&PESQUISAACESSO=S`;

        return filtros;
    }

    async function consultaCotacao() {
        $.LoadingOverlay("show");
        if ($.fn.DataTable.isDataTable('#tabelaCotacao')) {
            $('#tabelaCotacao').DataTable().destroy();
            $('#tabelaCotacao').empty();
        }
        try {
            const url = "/sisplan/cadastros/v1/fretecota?"
            const filtros = await retornaFiltros()
            const response = await requisicao('GET', url, filtros, null, 360000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                throw msgAlerta(jsonStr.mensagem);
            }

            if (jsonStr.length <= 0) {
                throw msgAlerta('Nenhum registro encontrado!');
            }

            await montaDataTable(jsonStr);

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function montaDataTable(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                data: k,
                title: k,
            })
        })

        $('#tabelaCotacao').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: true,
            order: [],
            colReorder: true,
            autoWidth: true,
            data: jsonStr,
            columns: dataSetCols,
            columnDefs: [
                {
                    render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    },
                    targets: [0],
                },
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    },
                    targets: [5],
                },
                {
                    className: "text-right",
                    render(data) {
                        if (data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                minimumFractionDigits: 2,
                            });
                        } else {
                            return parseFloat(0).toLocaleString("pt-br", {
                                minimumFractionDigits: 2,
                            });
                        }
                    },
                    targets: [10, 11],
                },
                {
                    visible: false,
                    targets: [18]
                }
            ],
            createdRow: function (row, data, dataIndex) {
                if ((data.FINALIZADO == 'S')) {
                    $(row).css('background-color', 'rgba(245, 81, 81, 1)');
                }
            }
        });
    }

    retornaHintRelatorio('btnImprimir', 'RelAcessoFreteCota')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/fretecota?`;
                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoFreteCota');
                const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelAcessoFreteCota');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $("#tabelaCotacao").on("click", "#btn-imprimirIndividual", async function () {
        $.LoadingOverlay('show');
        try {
          const data = $('#tabelaCotacao').DataTable().row($(this).parents('tr')).data();
          const url = `/sisplan/impressao/v1/fretecotaindividual?`;
    
          const filtros = `COTACAO=${data.COTACAO}`;
          const bImprimeAutomatico = await verificaImprimirAutomatico('RelFreteCotaIndividual');
          let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelFreteCotaIndividual');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }
    
        } catch (error) {
          console.error(error);
        } finally {
          $.LoadingOverlay('hide');
        }
      })

    $('#btnNovoTipo').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "fretecota/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaCotacao').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            const data = $('#tabelaCotacao').DataTable().row($(this).parents('tr')).data();
            if (data.FINALIZADO == 'S') {
                msgAlertaSemConfirmacao("Cotação finalizada, impossível alterar!");
                return;
            }
            const registroLiberado = await verificarRegistro('FRETECOTACAO', data.COTACAO);
            if (registroLiberado) {
                window.location.href = `fretecota/${data.COTACAO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCotacao').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            const data = $('#tabelaCotacao').DataTable().row($(this)).data();
            if (data.FINALIZADO == 'S') {
                msgAlertaSemConfirmacao("Cotação finalizada, impossível alterar!");
                return
            }
            const registroLiberado = await verificarRegistro('FRETECOTACAO', data.COTACAO);
            if (registroLiberado) {
                window.location.href = `fretecota/${data.COTACAO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCotacao').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaCotacao").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    $('#tabelaCotacao').on('click', '#btn-finalizar', async function () {
        msgAlerta('Você realmente deseja finalizar esta cotação de frete?', async () => {
            const data = $("#tabelaCotacao").DataTable().row($(this).parents("tr"));
            await finalizaCotacao(data, $(this));
        });
    });

    async function finalizaCotacao(data, linha) {
        $.LoadingOverlay('show')
        try {
            const valorLinha = data.data();
            const dadosDelete = `COTACAO=${valorLinha.COTACAO}` +
                `&PEDIDO=${valorLinha.PEDIDO}` +
                `&CODTRANS=${valorLinha.TRANSP}` +
                `&VALOR=${valorLinha.VALOR}`;
            const response = await requisicao("PUT", "/Sisplan/cadastros/v1/fretecota?", dadosDelete, null);
            if (!response) {
                return;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }


            criaMensagemSucesso('Cotação finalizada com sucesso!', async () => {
                valorLinha.FINALIZADO = 'S'
                $("#tabelaCotacao").DataTable().row(linha.parents("tr")).remove().draw(false);
                $("#tabelaCotacao").DataTable().row.add(valorLinha).draw(false);
            })

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                const valorLinha = data.data();
                const dadosDelete = `COTACAO=${valorLinha.COTACAO}` +
                    `&PEDIDO=${valorLinha.PEDIDO}` +
                    `&CODTRANS=${valorLinha.TRANSP}` +
                    `&VALOR=${valorLinha.VALOR}`;
                const response = await requisicao("DELETE", "/Sisplan/cadastros/v1/fretecota?", dadosDelete, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                criaMensagemSucesso('Exclusão efetuada com sucesso!', async () => {
                    data.remove().draw(false);
                })
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});