$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
        });
        driver.defineSteps([{
            element: '#txtIDCfe',
            popover: {
                title: 'Campo ID',
                description: 'Selecionar o ID da CF-e a ser complementada.',
                position: 'bottom'
            }
        },
        {
            element: '#tabelaItens_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os itens da CF-e a ser complementada.',
                position: 'top'
            }
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a CF-e complementar.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const emp_id = getCookie('emp_id');
    criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '400px');
    $('#btn-IDCfe').pesquisa_serverside(['#txtIDCfe', '#txtCfe', '#txtNumSerie', '#txtVenda', '#txtCaixa', '#txtCodCli', '#txtNatureza', '#txtCNPJ', '#txtChaveCfe'],
        ['ID', 'NRCUPOM', 'SERIE_SAT', 'CODVEN', 'CAIXA', 'CODCLI', 'NATUREZA', 'CNPJ', 'CHAVE_CFE'],
        ['ID', 'NRCUPOM', 'SERIE_SAT', 'CODVEN', 'CAIXA', 'CODCLI', 'NATUREZA', 'CNPJ', 'CHAVE_CFE'],
        `{"tabela":"CFE", "camposSelect":[ "EMP_ID", "ID", "FATURA", "MODELO", "SERIE_SAT", "CODVEN", "NRCUPOM", "CAIXA", "CODCLI", "NATUREZA", "CNPJ", "CHAVE_CFE" ], 
                                          "where": ["((CHAVE_CFE IS NOT NULL ) OR (CHAVE_CFE <> '')) AND EMP_ID = ${emp_id}"]}`, 'Pesquisa CF-e');

    $("#btn-limpar-IDCfe").on("click", function () {
        limpaTela();
    });

    $("#txtIDCfe").blur(async function () {
        const itens = await buscaItens();
        if (itens) {
            insereItens(itens);            
        }
    });

    async function buscaItens() {
        const filtros = `CFE_ITEN.ID_CFE = ${pegaChave('#txtIDCfe')} 
                         AND CFE_ITEN.EMP_ID = ${getCookie('emp_id')}
                         AND ((CFE.CHAVE_CFE IS NOT NULL) OR (CHAVE_CFE <> ''))`;

        const dadosSelect = {
            tabela: 'CFE_ITEN',
            camposSelect: [
                'CFE_ITEN.CODIGO',
                `CASE WHEN CFE_ITEN.TIPO_IT = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
                'CFE_ITEN.COR',
                'CFE_ITEN.TAM',
                'CFE_ITEN.QUANTIDADE',
                'CFE_ITEN.CLA_ICMS CST_ICMS',
                'CFE_ITEN.VALOR_LIQ VALOR',
                'CFE_ITEN.VALOR_ICMS',
                'CFE_ITEN.PERC_ICMS',
                `'' CST_ICMS_AJUSTE`,
                `'0' BASE_AJUSTE`,
                `'0' PERC_ICMS_AJUSTE`,
                `'0' VALOR_ICMS_AJUSTE`,
                'CFE_ITEN.UNIDADE',
                'CFE_ITEN.CLA_FIS',
                'CFE_ITEN.NATUREZA',
                'CFE_ITEN.TIPO_IT'
            ],
            innerJoin: [{ tabela: 'CFE', condicao: 'CFE.ID = CFE_ITEN.ID_CFE AND CFE.EMP_ID = CFE_ITEN.EMP_ID' }],
            leftJoin: [
                { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = CFE_ITEN.CODIGO' },
                { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = CFE_ITEN.CODIGO' }
            ],
            where: [filtros]
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            msgAlerta('Não foi possível buscar os dados dos itens.');
            return;
        }
        return retornoSelect;
    }

    function insereItens(sDados) {
        let i = 1;
        sDados.forEach(function (item) {
            item.CST_ICMS_AJUSTE = retornaInput('cstIcmsAjuste', i, '');
            item.BASE_AJUSTE = retornaInput('baseAjuste', i);
            item.PERC_ICMS_AJUSTE = retornaInput('percIcmsAjuste', i);
            item.VALOR_ICMS_AJUSTE = retornaInput('valorIcmsAjuste', i, 'maskItens', 'disabled');
            ++i;
        });
        const colunasItens = sDados.length > 0 ? Object.entries(sDados[0]).map(item => ({
            title: item[0],
            data: item[0]
        })) : [];

        if (sDados.length == 0) {
            limpaTabela();
        } else {
            criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '400px', sDados, colunasItens, [13,14,15,16], [], [], [6,7]);
        }

        $(".maskItens").maskMoney({
            decimal: ",",
            thousands: "",
            precision: 2,
        });
        $(".maskItens").on('blur', function () {
            const pos = $(this).attr('id').indexOf('-');
            const id = $(this).attr('id').slice(pos +1);
            if ($(this).attr('id').slice(0, pos) == 'valorIcmsAjuste') {
                return
            } else if ($(this).attr('id').slice(0, pos) == 'baseAjuste') {
                $(`#valorIcmsAjuste-${id}`).val(retornaValor($(this).val(), $(`#percIcmsAjuste-${id}`).val()));
            } else {
                $(`#valorIcmsAjuste-${id}`).val(retornaValor($(this).val(), $(`#baseAjuste-${id}`).val()));
            }
        });
    };

    function limpaTela() {
        $("#txtIDCfe").val("");
        $("#txtCfe").val("");
        $("#txtNumSerie").val("");
        $("#txtVenda").val("");
        $("#txtCaixa").val("");
        limpaTabela();
    };

    function limpaTabela() {
        $("#tabelaItens tr").remove();
    };

    function retornaInput(sCampo, iID, classe = 'maskItens', habilita = '') {
        const valor = classe == '' ? '' : '0,00';
        const max = classe == '' ? `maxlength="3" onkeypress="return event.charCode >= 48 && event.charCode <= 57"` : '';

        return `<div class="input-group">
                    <input type="text" ${max} class="inputs input-default focus form-control ${classe}" value="${valor}" id="${sCampo}-${iID}" name="${sCampo}-${iID}" ${habilita}>
                </div>`;
    }

    function retornaValor(value1, value2) {
        const valor = (value1.replace(',','.') * value2.replace(',','.')) / 100;
        return (valor) ? valor.toFixed(2).replace('.', ',') : 0;       
    }

    $('#btnGravar').click(async function () {
        await gravaDados();
    });

    async function gravaDados() {
        $.LoadingOverlay('show');
        try {
            if ($('#tabelaItens').DataTable().rows().count() == 0) {
                msgAlerta('CF-e complementar sem itens, impossível continuar!');
                $.LoadingOverlay("hide");
                return;
            }
    
            const cfeComplementar = {
                CODVEN: pegaChave('#txtCfe'),
                CAIXA: pegaChave('#txtCaixa'),
                CODCLI: pegaChave('#txtCodCli'),
                NATUREZA: pegaChave('#txtNatureza'),
                CNPJ: pegaChave('#txtCNPJ'),
                EMP_ID: getCookie('emp_id'),
                CHAVE_CFE: pegaChave('#txtChaveCfe'),
                ITENS: retornaItens()
            };
    
            const response = await requisicao('POST', '/sisplan/cfe/v1/cfe_complementar?', '', `JSON=${encodeURIComponent(JSON.stringify(cfeComplementar))}`, 90000);
    
            if (!response) {
                $.LoadingOverlay('hide');
                return;
            }
    
            const jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay('hide');
                msgAlerta(jsonStr.mensagem);
                return;
            }
    
            $.LoadingOverlay('hide');
            criaMensagemSucesso(`CF-e complementar gravada com sucesso!`, limpaTela());
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgAlerta(`Não foi possível gravar a CF-e complementar: ${error}`);
        }
    };    

    function retornaItens() {
        let arrItens = [];
        let index = 1;
        $('#tabelaItens').DataTable().rows().data().map(item => {
            arrItens.push({
                CODIGO: item.CODIGO,
                DESCRICAO: item.DESCRICAO,
                COR: item.COR,
                TAM: item.TAM,
                UNIDADE: item.UNIDADE,
                CLA_ICMS_AJUSTE: $(`#cstIcmsAjuste-${index}`).val(),
                CLA_ICMS: item.CST_ICMS,
                PERC_ICMS: $(`#percIcmsAjuste-${index}`).val().replace(',','.'),
                VALOR_ICMS: $(`#valorIcmsAjuste-${index}`).val().replace(',','.'),
                TIPO_IT: item.TIPO_IT,
                CLA_FIS: item.CLA_FIS,
                NATUREZA: item.NATUREZA,
                VALOR_OUTROS: $(`#baseAjuste-${index}`).val().replace(',','.')
            })
            ++index;
        });
        return arrItens;
    };        
})