$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtConta",
        popover: {
          title: "Conta",
          description: "Conta referente ao cadastro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Campos Obrigatórios",
          description: "Adicionamos aqui uma descrição sobre este cadastro.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description: "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a carteira.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#txtConta").autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "Conta CHAVE", "DESCRICAO"], "where": null}`);
  $("#btnConta").pesquisa("#txtConta", "CONTA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}`, "Pesquisa Conta", "CADCONTA");
  $("#btnLimpaConta").on("click", function () {
    $("#txtConta").val("");
  });

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtCodigo: {
        required: "Informe uma conta válido.",
      },
      txtDescricao: {
        required: "Informe uma descrição válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/carteira_pagamento`;
  });

  const conta = $(window.location.href.split('/')).get(-1);

  await carregaDados();

  async function carregaDados() {

    if (conta == 'create') {
      return;
    }

    $.LoadingOverlay("show");
    try {
      const pesquisaParam = {
        tabela: 'CARTEIRA',
        camposSelect: [
          'CARTEIRA.CONTA',
          'CARTEIRA.DESCRICAO',
          'CARTEIRA.CONVENIO',
          'CARTEIRA.NOME_ARQ',
          'CARTEIRA.EXTENSAO_ARQUIVO',
          'CARTEIRA.NOME_ARQUIVO',
          'CADCONTA.DESCRICAO DESC_CONTA'
        ],
        where: [`CARTEIRA.CONTA = '${conta}' AND CARTEIRA.CARTEIRA = 'P'`],
        leftJoin: [{ tabela: 'CADCONTA', condicao: 'CADCONTA.CONTA = CARTEIRA.CONTA' }]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      insereValor('#txtConta', jsonStr[0].CONTA, jsonStr[0].DESC_CONTA);
      insereValor('#txtDescricao', jsonStr[0].DESCRICAO);
      insereValor('#txtNomeArq', jsonStr[0].NOME_ARQ);
      insereValor('#txtConvenio', jsonStr[0].CONVENIO);
      insereValor('#txtExtArq', jsonStr[0].EXTENSAO_ARQUIVO);
      $('#rgPreencherNomeArq').val(jsonStr[0].NOME_ARQUIVO).change();

    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();

    if (erros != 0) {
      return;
    }

    $.LoadingOverlay('show');
    try {

      const cPagto = {
        CARTEIRA: 'P',
        CONTA: pegaChave('#txtConta'),
        DESCRICAO: pegaValor('#txtDescricao'),
        NOME_ARQ: pegaValor('#txtNomeArq'),
        CONVENIO: pegaValor('#txtConvenio'),
        EXTENSAO_ARQUIVO: pegaValor('#txtExtArq'),
        NOME_ARQUIVO: pegaValor('#rgPreencherNomeArq'),
      };

      const response = await requisicao('POST', '/sisplan/cadastros/v1/carteira?', `JSON=${encodeURIComponent(JSON.stringify(cPagto))}`, null);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/carteira_pagamento` })

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgAlerta(error);
    }
  });

});
