/* eslint-disable prefer-rest-params */
$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtPrazo',
            popover: {
                title: 'Código do Prazo',
                description: 'Adicionamos aqui o código relacionado ao prazo cadastrado.',
                position: 'top'
            }
        },
        {
            element: '#txtDesc',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o registro que estamos cadastrando ou alterando',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o prazo.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let prazo = parametros[parametros.length - 1];

    $(document).ready(function () {
        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtPrazo: {
                    required: true,
                },
                txtDesc: {
                    required: true,
                }
            },
            messages: {
                txtPrazo: {
                    required: "Informe um prazo válido."
                },
                txtDesc: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });


    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CADPRAZO', getCookie('usuario'), prazo);
        window.location.href = `${BASE_URI}/cadprazo`;
    });

    $('#txtPrazo').on('blur', async function () {
        if (prazo === 'create') {
            const prazo = $('#txtPrazo').val();
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"TABPRZ", 
                    "camposSelect":["DESCRICAO", "PRAZO"], 
                    "where": ["PRAZO = '${prazo}'"]}`, null);

            let json = await response.json();
            if (json.RESULT[0].length > 0) {
                msgAlerta('Código já existe. Favor verifique!');
                $('#txtPrazo').focus();
                return;
            }
        }
    });

    if (prazo != '' && prazo != 'create') {
        if (await liberarRegistro('CADPRAZO', prazo) == false) {
            window.location.href = '../cadprazo';
        } else {
            try {
                $.LoadingOverlay("show");

                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABPRZ", 
                            "camposSelect":["DESCRICAO", "PRAZO", "MINUTO", "DT_FIM", "DT_INICIO", "ATIVO", "ATIVO_PRODUCAO", "QTDE", "VALOR", "BLOQ_VENDA"], 
                            "where": ["PRAZO = '${prazo}'"]}`, null);

                    let json = await response.json();

                    $('#txtPrazo').val(json.RESULT[0][0].PRAZO);
                    $('#txtDesc').val(json.RESULT[0][0].DESCRICAO);
                    $('#txtMinutos').val(json.RESULT[0][0].MINUTO);
                    $('#txtDataIni').val(json.RESULT[0][0].DT_INICIO.slice(0, 10));
                    $('#txtDataFim').val(json.RESULT[0][0].DT_FIM.slice(0, 10));
                    $('#txtQtde').val(json.RESULT[0][0].QTDE);
                    $('#txtFaturamento').val(json.RESULT[0][0].VALOR);

                    if (json.RESULT[0][0].ATIVO == 'S') {
                        $('#checkAtivo').prop('checked', true);
                    }else {
                        $('#checkAtivo').prop('checked', false); 
                    }
                    if (json.RESULT[0][0].ATIVO_PRODUCAO == 'S') {
                        $('#checkAtivoProd').prop('checked', true);
                    }else {
                        $('#checkAtivoProd').prop('checked', false);
                    }
                    if (json.RESULT[0][0].BLOQ_VENDA == 'S') {
                        $('#checkBloq').prop('checked', true);
                    }else {
                        $('#checkBloq').prop('checked', false);
                    }
                } catch (error) {
                    console.error(error);
                }

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#gravar").click(async function () {
        $.LoadingOverlay("show");
        try {
            if ($('#txtPrazo').val() == '') {
                msgAlerta(`Necessário informar um prazo.`);
                return;
            }
            if ($('#txtDesc').val() == '') {
                msgAlerta(`Necessário informar uma descrição.`);
                return;
            }

            let prazo = {};

            prazo.PRAZO = $('#txtPrazo').val();
            prazo.MINUTO = $('#txtMinutos').val() === '' ? prazo.MINUTO = 0 : $('#txtMinutos').val();
            prazo.DESCRICAO = $('#txtDesc').val().toUpperCase();
            prazo.DT_INICIO = $('#txtDataIni').val() === '' ? prazo.DT_INICIO = '1899-12-30T00:00:00Z' : `${$('#txtDataIni').val()}T00:00:00Z`;
            prazo.DT_FIM = $('#txtDataFim').val() === '' ? prazo.DT_FIM = '1899-12-30T00:00:00Z' : `${$('#txtDataFim').val()}T00:00:00Z`;
            prazo.QTDE = $('#txtQtde').val() === '' ? prazo.QTDE = 0 : $('#txtQtde').val();
            prazo.VALOR = $('#txtFaturamento').val() === '' ? prazo.VALOR = 0 : $('#txtFaturamento').val();
            prazo.ATIVO = $('#checkAtivo').prop('checked') ? prazo.ATIVO = 'S' : prazo.ATIVO = 'N';
            prazo.ATIVO_PRODUCAO = $('#checkAtivoProd').prop('checked') ? prazo.ATIVO_PRODUCAO = 'S' : prazo.ATIVO_PRODUCAO = 'N';
            prazo.BLOQ_VENDA = $('#checkBloq').prop('checked') ? prazo.BLOQ_VENDA = 'S' : prazo.BLOQ_VENDA = 'N';


            let response = await requisicao('POST', '/sisplan/cadastros/v1/cadprazo?', '', `JSON=${JSON.stringify(prazo)}`, 15000);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
                'Cadastro efetuado com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/cadprazo`;
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });
        } catch (error) {
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados do prazo.`);
        }
        finally{
            $.LoadingOverlay("hide")
        }
    });
});