/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    // $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#multiCollapseExample1').hasClass('show')) {
                        $('#multiCollapseExample1').collapse('show');
                    }
                } else if (Element.node.id == 'itens') {
                    if (!$('#multiCollapseExample2').hasClass('show')) {
                        $('#multiCollapseExample2').collapse('show');
                    }
                } else if (Element.node.id == 'aviamentos') {
                    if (!$('#multiCollapseExample3').hasClass('show')) {
                        $('#multiCollapseExample3').collapse('show');
                    }
                } else if (Element.node.id == 'compras') {
                    if (!$('#multiCollapseExample4').hasClass('show')) {
                        $('#multiCollapseExample4').collapse('show');
                    }
                }
            },
            onPrevious: (Element) => {
                if (
                    Element.node.id == "geral"
                ) {
                    if ($("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample1").collapse("show");
                    }
                } else if (Element.node.id == "dados-contratuais") {
                    if ($("#itens>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "dados-pagamento") {
                    if ($("#aviamentos>a").hasClass("collapsed")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                } else if (Element.node.id == "outros") {
                    if ($("#compras>a").hasClass("collapsed")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                }
            }
        });

        driver.defineSteps([{
            element: '#geral',
            popover: {
                title: 'Aba Geral',
                description: 'Clique aqui para abrir a aba geral.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample1',
            popover: {
                title: 'Dados Gerais',
                description: 'Esses são os campos que você preencherá com os dados gerais de cadastro.',
                position: 'top'
            }
        },
        {
            element: '#itens',
            popover: {
                title: 'Aba Cores',
                description: 'Clique aqui para abrir a aba cores/itens.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample2',
            popover: {
                title: 'Dados de Cores',
                description: 'Aqui ficam as cores e preços das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnControleItens',
            popover: {
                title: 'Modal Controle de Itens',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnQuebras',
            popover: {
                title: 'Modal Quebras',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção das quebras do material.',
                position: 'top'
            }
        },
        {
            element: '#btnPrecoTinturaria',
            popover: {
                title: 'Modal Preço Tinturaria',
                description: 'Clicando neste botão abrirá um modal para buscar o preço da tinturaria das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnCustoMalhas',
            popover: {
                title: 'Modal Custo Malha',
                description: 'Clicando neste botão abrirá um modal para buscar o custo das malhas do material.',
                position: 'top'
            }
        },
        {
            element: '#aviamentos',
            popover: {
                title: 'Aba Aviamentos',
                description: 'Clique aqui para abrir a aba aviamentos.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample3',
            popover: {
                title: 'Dados de Aviamentos',
                description: 'Aqui ficam os aviamentos e preços dos aviamentos do material.',
                position: 'top'
            }
        },
        {
            element: '#btnAviamentos',
            popover: {
                title: 'Modal Aviamentos',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção dos aviamentos do material.',
                position: 'top'
            }
        },
        {
            element: '#compras',
            popover: {
                title: 'Aba Últimas Compras',
                description: 'Clique aqui para abrir a aba últimas compras.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample4',
            popover: {
                title: 'Últimas Compras',
                description: 'Aqui ficam as últimas compras do material.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: 'Botão Voltar',
                description: 'Ao clicar nesse botão você retorna para a tela de consulta.',
                position: "left",
            },
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Ao clicar nesse botão você grava os dados inseridos.',
                position: 'left'
            }
        }
        ]);

        driver.start();
    });
});


$(document).ready(async function () {

    const queryString = window.location.href;
    const parametros = queryString.split('/');
    let codMat = parametros[parametros.length - 1];

    if (codMat != 'create') {
        $('#txtCodigo').prop('disabled', true);
        $('#txtCodigo').prop('readonly', true);
        $('#btnCodigo').prop('disabled', true);
        $('#btnCodigo').prop('readonly', true);
        carregarCadastro(codMat)
    } else {
        $('.create').prop('disabled', true);
    }

    componenteFiltro('grupoPreco', false, false, 'Grupo')
    componenteFiltro('setor', false, false)
    componenteFiltro('parte', false, false)

    function carregarCadastro(codigo) {
        $.LoadingOverlay('show')
        buscarDadosCadastro(codigo).then((dados) => {
            if (!dados) {
                return
            }
            if (dados.capa) {
                alimentarDadosCapa(dados.capa)
            }
            criarTabelaCores(dados.cores)
            criarTabelaAviamentos(dados.aviamentos)
            alimentarUltimasCompras(dados.ultimasCompras)
            carregarFoto(codigo)
            $('#tituloModalAviamentos').html(`[${dados.capa?.codigo} - ${dados.capa?.descricao}] - Aviamentos`)
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao carregar os dados.')
        }).finally(() => {
            $.LoadingOverlay('hide')
        })
    }

    async function buscarDadosCadastro(codigo) {
        const response = await requisicao("GET", `/sisplan/cadmatpreco/v1/dadoscadastro?`, `CODIGO=${encodeURIComponent(codigo)}`, '', 3600000)

        const json = await response.json()

        if (json) {
            const { resultado, mensagem } = json
            if (mensagem?.codigo !== 200) {
                throw mensagem?.mensagem
            }

            return resultado
        }
    }

    function alimentarDadosCapa(dados) {
        $('#cbProduzido').prop('checked', dados.produzido)
        $('#txtCodigo').val(dados.codigo)
        $('#txtDescricao').val(dados.descricao)
        $('#txtUnidade').val(dados.unidade)
        $('#txtData').val(retornarDataISOEmYMD({ dataISO: dados.data }))
        $('#txtDataUltimaAtualizacao').val(retornarDataISOEmYMD({ dataISO: dados.ultimaAtualizacao }))
        insereValor('#txtGrupo', dados.grupo, dados.descricaoGrupo)
        insereValor('#txtSetor', dados.setor, dados.descricaoSetor)
        insereValor('#txtParte', dados.parte, dados.descricaoParte)
        $('#txtPrecoCompra').val(retornarFloatFormatadoEmMonetario({ valor: dados.precoCompra, quantidadeCasasDecimais: 6 }))
        $('#txtCreditoIPI').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualIpi }))
        $('#cbCreditoIPI').prop('checked', dados.creditaIpi)
        $('#txtCreditoICMS').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualIcms }))
        $('#cbCreditoICMS').prop('checked', dados.creditaIcms)
        $('#txtCreditoPIS').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualPis }))
        $('#cbCreditoPIS').prop('checked', dados.creditaPis)
        $('#txtCreditoCOFINS').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualCofins }))
        $('#cbCreditoCOFINS').prop('checked', dados.creditaCofins)
        $('#txtDespesasIPI').val(retornarFloatFormatadoEmMonetario({ valor: dados.despesasIpi }))
        $('#txtFrete').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualFrete }))
        $('#txtValorFrete').val(retornarFloatFormatadoEmMonetario({ valor: dados.valorFrete }))
        $('#txtFatorConversao').val(retornarFloatFormatadoEmMonetario({ valor: dados.fatorConversao }))
        $('#txtAproveitamento').val(retornarFloatFormatadoEmMonetario({ valor: dados.aproveitamento }))
        $('#txtPrecoAnterior').val(retornarFloatFormatadoEmMonetario({ valor: dados.preco4 }))
        $('#txtMVA').val(retornarFloatFormatadoEmMonetario({ valor: dados.mva }))
        $('#txtPreco1').val(retornarFloatFormatadoEmMonetario({ valor: dados.preco1, quantidadeCasasDecimais: 6 }))
        $('#txtPreco2').val(retornarFloatFormatadoEmMonetario({ valor: dados.preco2, quantidadeCasasDecimais: 6 }))
        $('#txtPreco3').val(retornarFloatFormatadoEmMonetario({ valor: dados.preco3, quantidadeCasasDecimais: 6 }))
        $('#txtLarguraMalha').val(retornarFloatFormatadoEmMonetario({ valor: dados.largura }))
        $('#txtGramatura').val(retornarFloatFormatadoEmMonetario({ valor: dados.gramatura }))
        $('#txtIndicePeso').val(retornarFloatFormatadoEmMonetario({ valor: dados.indicePeso }))
        $('#txtInformacoesComplementares').val(dados.informacoesComplementares)
        $('#txtObs').val(dados.observacao)
    }

    function criarTabelaCores(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaCores')) {
            $('#tabelaCores').DataTable().destroy()
            $('#tabelaCores').empty()
        }

        const columns = [
            {
                data: 'id',
                title: 'Id',
            },
            {
                data: 'ativo',
                title: 'Ativo',
                render: function (data) {
                    return data ? 'S' : 'N'
                }
            },
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'precoTingimento',
                title: 'Preço Tingimento',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'precoCompra',
                title: 'Preço Compra',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'percentualDesperdicio',
                title: '% Desperdício',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'preco',
                title: 'Preço',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'pantone',
                title: 'Pantone',
            },
            {
                data: 'tinturaria',
                title: 'Tinturaria',
            },
            {
                data: 'nome',
                title: 'Nome',
            },
            {
                data: 'codigo2',
                title: 'Código 2',
            },
            {
                data: 'grupo',
                title: 'Grupo',
            },
            {
                data: 'descricaoGrupo',
                title: 'Descrição Grupo',
            },
            {
                data: 'fatorConversao',
                title: 'Fator Conversão',
                visible: false,
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario()
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
                },
            },
        ]

        $("#tabelaCores").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    function criarTabelaAviamentos(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaAviamentos')) {
            $('#tabelaAviamentos').DataTable().destroy()
            $('#tabelaAviamentos').empty()
        }

        const columns = [
            {
                data: 'ordem',
                title: 'Ordem',
            },
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'unidade',
                title: 'Unidade',
            },
            {
                data: 'quantidade',
                title: 'Quantidade',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 4 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 4 })
                },
            },
            {
                data: 'custo',
                title: 'Custo',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'quebra',
                title: 'Quebra',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 4 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 4 })
                },
            },
            {
                data: 'valor',
                title: 'Valor',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'acumulado',
                title: 'Acumulado',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'ultimaAtualizacao',
                title: 'Atualizado Em',
                render: function (data) {
                    return retornarDataISOEmYMD({ dataISO: data, separador: '/', reverso: true })
                }
            },
        ]

        $("#tabelaAviamentos").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    function alimentarUltimasCompras() { }

    $('#cbEsconderFoto').on('change', function () {
        if ($('#cbEsconderFoto').prop('checked') == true) {
            $('#divImagem').addClass('d-none');
            $('#infoGerais').addClass('col-12');
        } else {
            $('#divImagem').removeClass('d-none');
            $('#infoGerais').removeClass('col-12');
            $('#infoGerais').addClass('col-8');
        }
    });

    function carregarFoto(codigo) {
        buscarFoto(codigo).then((fotoBase64) => {
            $("#imagemMat").attr('src', fotoBase64)
        })
    }

    async function buscarFoto(codigo) {
        try {
            const response = await requisicao('GET', '/sisplan/Funcoes/v1/FotoItem?', `codigo=${codigo}`, null)

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw jsonStr.mensagem
            }

            return `data:image/png;base64,${jsonStr.mensagem}`
        } catch (error) {
            console.error(error)
            return `${BASE_URI}/dist/img/prod-1.png`
        }
    }

    $('#txtCodigo').on('blur', async function () {
        validarSeCodigoInformadoJaExiste(this.value)
    });

    async function validarSeCodigoInformadoJaExiste(codigo) {
        try {
            $.LoadingOverlay('show')
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"MAT_PRECO",
                "camposSelect":["CODIGO, TIPO"],
                "where": ["MAT_PRECO.CODIGO = '${codigo}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`, null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            const [dadosItemJaCadastrado] = jsonStr?.RESULT[0];

            if (!dadosItemJaCadastrado) {
                return
            }

            msgAlerta(
                'Item já cadastrado, deseja alterar os dados?',
                () => {
                    if (dadosItemJaCadastrado.TIPO == 'M' || !dadosItemJaCadastrado.TIPO) {
                        carregarCadastro(codigo)
                        $('.create').prop('disabled', false)
                        $('#txtCodigo').prop('disabled', true)
                    } else {
                        window.location.href = `${BASE_URI}/cadprodpreco/${codigo}`;
                    }
                },
                () => {
                    $('.create').prop('disabled', true);
                    $('#txtCodigo').val('');
                    $('#txtDescricao').val('');
                    $('#txtUnidade').val('');
                    codMat = codigo
                })
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao validar os dados.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function alimentarUltimasCompras(dados) {
        const conteudoUltimasCompras = retornarConteudoUltimasCompras(dados)
        $('#cardbody-compras').append(conteudoUltimasCompras)
    }

    function retornarConteudoUltimasCompras(dados) {

        $('#cardbody-compras').empty();

        let card = '';

        if (dados?.length > 0) {

            card = '<div class="scroll" style="max-height: 500px; overflow-y: scroll">' +
                '<div style="background-color: white; height: 1px;">' +
                '</div>';


            dados.forEach((compra) => {

                card += '<div class="card col-12">' +
                    '<div style="background-color: var(--font-color); height: 1px;">' +
                    '</div>' +
                    '<div class="form-row pl-1 pt-2 col-12">' +
                    '<h6 class="col-9"><b>Fornecedor:</b> [' +
                    compra.codigoFornecedor + '] - ' + compra.nomeFornecedor +
                    '</h6>' +
                    '<h6 class="col-3"><b>Nota:</b> ' +
                    compra.notaFiscal +
                    '</h6>' +
                    '</div>' +
                    '<div class="form-row pl-1 col-12">' +
                    '<h6 class="col-2"><b>Data:</b> ' +
                    retornarDataISOEmYMD({ dataISO: compra.dataEntrada, separador: '/', reverso: true }) +
                    '</h6>' +
                    '<h6 class="col-3"><b>Unidade de Compra:</b> ' +
                    compra.unidadeCompra +
                    '</h6>' +
                    '<h6 class="col-2"><b>Redução ICMS:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.percentualIcmsReduzido }) +
                    '</h6>' +
                    '<h6 class="col-2"><b>Quantidade:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.quantidade }) +
                    '</h6>' +
                    '<h6 class="col-3"><b>Preço:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.valor }) +
                    '</h6>' +
                    '</div' +
                    '<div class="form-row pl-1 pt-1 col-12">' +
                    '<h6 class="col-2"><b>Fator Conversão:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.fatorConversao }) +
                    '</h6>' +
                    '<h6 class="col-3"><b>Preço Convertido:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.precoConvertido }) +
                    '</h6>' +
                    '<h6 class="col-2"><b>Val Uni ICMS:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.valorUnitarioIcms }) +
                    '</h6>' +
                    '<h6 class="col-2"><b>Val Uni IPI:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.valorUnitarioIpi }) +
                    '</h6>' +
                    '<h6 class="col-3"><b>Custo Mat_Mov:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.custo }) +
                    '</h6>' +
                    '</div> ' +
                    '<div style="background-color: var(--font-color); height: 1px;">' +
                    '</div>' +
                    '</div>';
            })
        } else {
            card = '<div class="scroll flex" style="max-height: 500px">' +
                '<div style="background-color: var(--font-color); height: 1px;">' +
                '</div>';

            card += '<div class="d-flex justify-content-center">' +
                '<h6 class="my-3"><b>Nenhum registro encontrato</b>' +
                '</h6>' +
                '</div>'
        }

        card += '<div style="background-color: var(--font-color); height: 1px;">' +
            '</div>' +
            '</div>';

        return card
    }

    $('#multiCollapseExample2').on('shown.bs.collapse', function () {
        $('#tabelaCores').DataTable().columns.adjust().draw(false)
    });

    $('#multiCollapseExample3').on('shown.bs.collapse', function () {
        $('#tabelaAviamentos').DataTable().columns.adjust().draw(false)
    });

    $('.campoRecalcularCusto').on('blur', function () {
        const valoresCalcularCusto = retornarValoresCalcularCusto()
        const custo = retornarCustoCalculado(valoresCalcularCusto)
        $('#txtPreco1').val(retornarFloatFormatadoEmMonetario({ valor: custo, quantidadeCasasDecimais: 6 }))
    })

    $('.cbRecalcularCusto').on('change', function () {
        const valoresCalcularCusto = retornarValoresCalcularCusto()
        const custo = retornarCustoCalculado(valoresCalcularCusto)
        $('#txtPreco1').val(retornarFloatFormatadoEmMonetario({ valor: custo, quantidadeCasasDecimais: 6 }))
    })

    function retornarValoresCalcularCusto() {
        const precoCompra = retornarValorMonetarioEmFloat($('#txtPrecoCompra').val())
        const descontarIpi = $('#cbCreditoIPI').prop('checked')
        const percentualIpi = retornarValorMonetarioEmFloat($('#txtCreditoIPI').val())
        const descontarIcms = $('#cbCreditoICMS').prop('checked')
        const percentualIcms = retornarValorMonetarioEmFloat($('#txtCreditoICMS').val())
        const descontarPis = $('#cbCreditoPIS').prop('checked')
        const percentualPis = retornarValorMonetarioEmFloat($('#txtCreditoPIS').val())
        const descontarCofins = $('#cbCreditoCOFINS').prop('checked')
        const percentualCofins = retornarValorMonetarioEmFloat($('#txtCreditoCOFINS').val())
        const percentualFrete = retornarValorMonetarioEmFloat($('#txtFrete').val())
        const valorFrete = retornarValorMonetarioEmFloat($('#txtValorFrete').val())
        const despesasIpi = retornarValorMonetarioEmFloat($('#txtDespesasIPI').val())
        const mva = retornarValorMonetarioEmFloat($('#txtMVA').val())

        return {
            precoCompra,
            descontarIpi,
            percentualIpi,
            descontarIcms,
            percentualIcms,
            descontarPis,
            percentualPis,
            descontarCofins,
            percentualCofins,
            percentualFrete,
            valorFrete,
            despesasIpi,
            mva,
        }
    }

    function retornarCustoCalculado({
        precoCompra,
        descontarIpi,
        percentualIpi,
        descontarIcms,
        percentualIcms,
        descontarPis,
        percentualPis,
        descontarCofins,
        percentualCofins,
        percentualFrete,
        valorFrete,
        despesasIpi,
        mva,
    }) {
        try {
            if (precoCompra > 0) {
                let preco = precoCompra;

                if (descontarIpi) {
                    preco -= precoCompra * (percentualIpi / 100);
                };

                if (descontarIcms) {
                    preco -= precoCompra * (percentualIcms / 100);
                };

                if (descontarPis) {
                    preco -= precoCompra * (percentualPis / 100);
                };

                if (descontarCofins) {
                    preco -= precoCompra * (percentualCofins / 100);
                };

                preco += (precoCompra * (percentualFrete / 100)) + valorFrete;

                preco += precoCompra * (despesasIpi / 100);

                preco += precoCompra * (mva / 100);

                impostos = preco / precoCompra;

                if (precoCompra == 1000) {
                    precoCompra = 0;
                    preco = 0;
                };

                return preco
            }
        } catch (error) {
            console.error(error);
            msgErro(`Ocorreu um erro ao buscar os dados.`);
        }
    };

    $('#btnGravar').on('click', async function () {
        const dadosGravar = retornarDadosGravar()
        if (!validarDadosGravar(dadosGravar)) {
            return
        }

        msgAlerta('Deseja gravar os dados?', async () => {
            gravar(dadosGravar)
        });
    });

    function retornarDadosGravar() {
        const capa = retornarCapaGravar()
        const cores = retornarCoresGravar()
        const aviamentos = retornarAviamentosGravar()
        const quebras = retornarQuebrasGravar()

        return {
            capa,
            cores,
            aviamentos,
            quebras,
        }
    }

    function retornarCapaGravar() {
        const produzido = $('#cbProduzido').prop('checked')
        const codigo = $('#txtCodigo').val()
        const descricao = $('#txtDescricao').val()
        const unidade = $('#txtUnidade').val()
        const grupo = pegaChave('#txtGrupo')
        const setor = pegaChave('#txtSetor')
        const parte = pegaChave('#txtParte')
        const precoCompra = retornarValorMonetarioEmFloat($('#txtPrecoCompra').val())
        const preco1 = retornarValorMonetarioEmFloat($('#txtPreco1').val())
        const preco2 = retornarValorMonetarioEmFloat($('#txtPreco2').val())
        const preco3 = retornarValorMonetarioEmFloat($('#txtPreco3').val())
        const preco4 = retornarValorMonetarioEmFloat($('#txtPreco4').val())
        const percentualIpi = retornarValorMonetarioEmFloat($('#txtCreditoIPI').val())
        const creditaIpi = $('#txtCreditoIPI').prop('checked')
        const percentualIcms = retornarValorMonetarioEmFloat($('#txtCreditoICMS').val())
        const creditaIcms = $('#txtCreditoICMS').prop('checked')
        const percentualPis = retornarValorMonetarioEmFloat($('#txtCreditoPIS').val())
        const creditaPis = $('#cbCreditoPIS').prop('checked')
        const percentualCofins = retornarValorMonetarioEmFloat($('#txtCreditoCOFINS').val())
        const creditaCofins = $('#txtCreditoCOFINS').prop('checked')
        const despesasIpi = retornarValorMonetarioEmFloat($('#txtDespesasIPI').val())
        const percentualFrete = retornarValorMonetarioEmFloat($('#txtFrete').val())
        const valorFrete = retornarValorMonetarioEmFloat($('#txtValorFrete').val())
        const fatorConversao = retornarValorMonetarioEmFloat($('#txtFatorConversao').val())
        const aproveitamento = retornarValorMonetarioEmFloat($('#txtAproveitamento').val())
        const data = $('#txtData').val()
        const ultimaAtualizacao = $('#txtDataUltimaAtualizacao').val()
        const largura = retornarValorMonetarioEmFloat($('#txtLarguraMalha').val())
        const gramatura = retornarValorMonetarioEmFloat($('#txtGramatura').val())
        const indicePeso = retornarValorMonetarioEmFloat($('#txtIndicePeso').val())
        const mva = retornarValorMonetarioEmFloat($('#txtMVA').val())
        const informacoesComplementares = $('#txtInfoCompl').val()
        const observacao = $('#txtObs').val()

        return {
            produzido,
            codigo,
            descricao,
            unidade,
            grupo,
            setor,
            parte,
            precoCompra,
            preco1,
            preco2,
            preco3,
            preco4,
            percentualIpi,
            creditaIpi,
            percentualIcms,
            creditaIcms,
            percentualPis,
            creditaPis,
            percentualCofins,
            creditaCofins,
            despesasIpi,
            percentualFrete,
            valorFrete,
            fatorConversao,
            aproveitamento,
            data,
            ultimaAtualizacao,
            largura,
            gramatura,
            indicePeso,
            mva,
            informacoesComplementares,
            observacao,
        }
    }

    function retornarCoresGravar() {
        return $('#tabelaCores').DataTable().data().toArray()
    }

    function retornarAviamentosGravar() {
        return $('#tabelaAviamentos').DataTable().data().toArray()
    }

    function retornarQuebrasGravar() {
        return $('#tabelaQuebras').DataTable().data().toArray()
    }

    function validarDadosGravar(dados) {
        if (!dados) {
            msgErro('Dados inválidos, impossível continuar..')
            return false
        }

        if (!dados.capa?.codigo) {
            msgErro('Código não informado, impossível continuar.')
            return false
        }

        if (!dados.capa?.descricao) {
            msgErro('Descrição não informada, impossível continuar.')
            return false
        }

        if (!dados.capa?.grupo) {
            msgErro('Grupo não informado, impossível continuar.')
            return false
        }

        return true
    }

    async function gravar(dados) {
        try {
            $.LoadingOverlay('show')
            const response = await requisicao('POST', `/sisplan/cadmatpreco/v1/dadoscadastro?`, '', JSON.stringify(dados), 3600000)

            const json = await response.json()

            if (json) {
                const { mensagem } = json
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }
            }

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                onHidden() {
                    window.location.href = `${BASE_URI}/cadmatpreco`
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 1000,
                fadeOut: 1000,
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            })
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao gravar os dados.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnAviamentos').on('click', async function () {
        carregarModalAviamentos()
    });

    function carregarModalAviamentos() {
        try {
            const dados = $('#tabelaAviamentos').DataTable().data().toArray()
            criarTabelaModalAviamentos(dados)

            $('#modalAviamentos').modal('show');
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao carregar os dados.')
        }
    }

    let indiceLinhaSelecionadaTabelaModalAviamentos = 0

    function criarTabelaModalAviamentos(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaModalAviamentos')) {
            $('#tabelaModalAviamentos').DataTable().destroy()
            $('#tabelaModalAviamentos').empty()
        }

        const columns = [
            {
                data: 'ordem',
                title: 'Ordem',
            },
            {
                data: 'codigo',
                title: 'Código',
                render: function (value, _1, _2, { row }) {
                    return `<div>
                    <div class="input-group flex-nowrap">
                      <input type="text" class="input-default focus form-control stepControlModalAviamentos${row}" id="txtCodigoModalAviamentos${row}" value="${value}" name="txtCodigoModalAviamentos${row}" placeholder="Código" style="min-width: 20ch">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnCodigoModalAviamentos${row}" name="btnCodigoModalAviamentos${row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      </div>
                    </div>
                  </div>`
                }
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'unidade',
                title: 'Unidade',
            },
            {
                data: 'quantidade',
                title: 'Quantidade',
                className: 'text-right',
                render: function (value, _1, _2, { row }) {
                    const formattedValue = parseFloat(value).toLocaleString("pt-br", {
                        maximumFractionDigits: 4,
                        minimumFractionDigits: 4,
                    })
                    return `<div class="input-group-append justify-content-end">
                      <input type="text" value="${formattedValue}" style="min-width: 15ch; max-width: 20ch" class="input-default focus form-control validate text-right quatroCasasDecimaisQuantityFormat stepControlModalAviamentos${row}" id="txtQuantidadeModalAviamentos${row}" name="txtQuantidadeModalAviamentos${row}" placeholder="0,0000">
                  </div>`
                },
            },
            {
                data: 'custo',
                title: 'Custo',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'quebra',
                title: 'Quebra',
                className: 'text-right',
                render: function (value, _1, _2, { row }) {
                    const formattedValue = parseFloat(value).toLocaleString("pt-br", {
                        maximumFractionDigits: 4,
                        minimumFractionDigits: 4,
                    })
                    return `<div class="input-group-append justify-content-end">
                      <input type="text" value="${formattedValue}" style="min-width: 15ch; max-width: 20ch" class="input-default focus form-control validate text-right quatroCasasDecimaisQuantityFormat stepControlModalAviamentos${row}" id="txtQuebraModalAviamentos${row}" name="txtQuebraModalAviamentos${row}" placeholder="0,0000">
                  </div>`
                },
            },
            {
                data: 'valor',
                title: 'Valor',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'acumulado',
                title: 'Acumulado',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'ultimaAtualizacao',
                title: 'Atualizado Em',
                render: function (data) {
                    return retornarDataISOEmYMD({ dataISO: data, separador: '/', reverso: true })
                }
            },
        ]

        const table = $("#tabelaModalAviamentos").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '275px',
            select: {
                style: 'single',
                toggleable: false,
            },
        }).draw(false)

        function selectRow(index) {
            const row = table.row(index)
            if (row.node()) {
                table.rows().deselect()
                row.select()
            }
        }

        $('#tabelaModalAviamentos_wrapper .dataTables_scrollBody').off('wheel')
        $('#tabelaModalAviamentos_wrapper .dataTables_scrollBody').on('wheel', function (event) {
            event.preventDefault()

            const direction = event.originalEvent.deltaY > 0 ? 1 : -1
            const newIndex = indiceLinhaSelecionadaTabelaModalAviamentos + direction

            if (newIndex >= 0 && newIndex < table.rows().count()) {
                selectRow(newIndex)

                const rowNode = table.row(newIndex).node()
                $(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
            }
        })

        table.off('select')
        table.on('select', function (_e, _dt, type, indexes) {
            if (type === 'row') {
                indiceLinhaSelecionadaTabelaModalAviamentos = indexes[0]
            }
        })

        $(document).off('keydown')
        $(document).on('keydown', function (event) {
            if ((event.key === 'ArrowDown' || event.key === 'ArrowUp')) {
                event.preventDefault()

                const direction = event.key === 'ArrowDown' ? 1 : -1
                const newIndex = indiceLinhaSelecionadaTabelaModalAviamentos + direction

                if (newIndex >= 0 && newIndex < table.rows().count()) {
                    selectRow(newIndex)
                    const rowNode = table.row(newIndex).node()
                    $(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
                }
            }
        })

        selectRow(indiceLinhaSelecionadaTabelaModalAviamentos)
        adicionarEventosAviamentos(table)
    }

    $('#modalAviamentos').on('shown.bs.modal', function () {
        $('#tabelaModalAviamentos').DataTable().columns.adjust().draw(false)
    })

    $('#btnExcluirModalAviamentos').on('click', function () {
        excluirAviamento()
    })

    function excluirAviamento() {
        let datatable = $('#tabelaModalAviamentos').DataTable()
        const indicesSelecionados = datatable.rows({ selected: true }).indexes().toArray()
        if (!indicesSelecionados || indicesSelecionados.length === 0) {
            msgErro('Nenhum registro selecionado, impossível continuar.')
            return
        }
        if (indicesSelecionados.length > 1) {
            msgErro('Ocorreu um erro ao excluir, por favor tente novamente.')
            data.row(0).select()
            return
        }
        const [indiceSelecionado] = indicesSelecionados
        datatable.row(indiceSelecionado).remove()
        recalcularDadosTabelaModalAviamentos()
        datatable = $('#tabelaItensAlteracao').DataTable()
        const ultimoIndiceDisponivel = datatable.rows().count() - 1
        const proximoIndiceASerSelecionado = indiceSelecionado > ultimoIndiceDisponivel ? ultimoIndiceDisponivel : indiceSelecionado
        if (proximoIndiceASerSelecionado >= 0) {
            const row = datatable.row(proximoIndiceASerSelecionado)
            row.select()
            setTimeout(() => {
                $(row.node()).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
            }, 150)
        }
    }

    $('#tabelaModalAviamentos').on('draw.dt', function () {
        aplicarEstilosCamposDecimais()
    })

    function retornarPesquisaAviamentos(codigo) {
        const pesquisa = {
            camposSelect: [
                'CODIGO',
                'DESCRICAO',
                'UNIDADE',
                'PRECO_1 CUSTO',
                'DT_ULT_ATUALIZACAO ATUALIZADO_EM',
            ],
            tabela: 'MAT_PRECO',
            groupBy: [
                'CODIGO',
                'DESCRICAO',
                'UNIDADE',
                'PRECO_1',
                'DT_ULT_ATUALIZACAO',
            ],
            camposSelectSubSelect: [
                'CODIGO',
                'DESCRICAO',
                'UNIDADE',
                'CUSTO',
                'ATUALIZADO_EM',
            ],
            groupBySubSelect: [
                'CODIGO',
                'DESCRICAO',
                'UNIDADE',
                'CUSTO',
                'ATUALIZADO_EM',
            ],
            camposWhereServerSide: [
                'CODIGO',
                'DESCRICAO',
            ]
        }

        if (codigo) {
            pesquisa.where = [`MAT_PRECO.CODIGO = '${codigo}'`]
        }

        return pesquisa
    }

    function adicionarEventosBotoesAviamentos(index, row) {
        $(`#btnCodigoModalAviamentos${index}`).pesquisa_serverside(
            [`#txtCodigoModalAviamentos${index}`],
            ['CODIGO', 'DESCRICAO'],
            ['DESCRICAO', 'DESCRICAO'],
            JSON.stringify(retornarPesquisaAviamentos()),
            'Pesquisa Item',
            () => {
                setTimeout(() => {
                    const valorSelecionado = $(`#txtCodigoModalAviamentos${index}`).val()
                    atualizarAviamentoComDadosDoCodigoInformado(valorSelecionado, index, row)
                }, 0)
            },
            [true],
        )
    }

    let debounceTimer;

    function adicionarEventosInputsAviamentos(index, row) {

        $(`#txtCodigoModalAviamentos${index}`).on('focus', function () {
            const input = this
            input.selectionStart = input.selectionEnd = input.value.length
        })

        let enterCampoCodigoFoiPressionado = false
        $(`#txtCodigoModalAviamentos${index}`)
            .on('keydown', function (e) {
                if (e.key === 'Enter') {
                    e.preventDefault()
                    enterCampoCodigoFoiPressionado = true
                    $(`#txtQuantidadeModalAviamentos${index}`).focus()
                    return
                }
            })
            .on('input', function () {
                if (debounceTimer) {
                    clearTimeout(debounceTimer);
                }

                if (enterCampoCodigoFoiPressionado) {
                    enterCampoCodigoFoiPressionado = false
                    return
                }

                debounceTimer = setTimeout(async () => {
                    try {
                        const valorDigitado = this.value
                        if (!valorDigitado) {
                            return
                        }
                        $(this).prop('disabled', true)
                        await atualizarAviamentoComDadosDoCodigoInformado(valorDigitado, index, row)
                        $(`#txtCodigoModalAviamentos${index}`).focus()
                    } finally {
                        $(this).prop('disabled', false)
                    }
                }, 300);
            })

        let enterCampoQuantidadeFoiPressionado = false
        $(`#txtQuantidadeModalAviamentos${index}`)
            .on('keydown', function (e) {
                enterCampoQuantidadeFoiPressionado = (e.key === 'Enter')
                if (enterCampoQuantidadeFoiPressionado) {
                    e.preventDefault()
                    $(this).blur()
                }
            })
            .on('blur', function () {
                try {
                    const quantidade = retornarValorMonetarioEmFloat(this.value)
                    const quebra = retornarValorMonetarioEmFloat($(`#txtQuebraModalAviamentos${index}`).val())
                    const data = row.data()
                    const custo = retornarValorMonetarioEmFloat(data.custo)
                    const valor = retornarValorAviamento({ custo, quantidade, quebra })

                    if (!valor || isNaN(valor)) {
                        row.data({ ...data, quantidade: 0, quebra: 0, valor: 0 })
                    } else {
                        row.data({ ...data, quantidade, quebra, valor })
                    }
                    recalcularDadosTabelaModalAviamentos()

                    if (enterCampoQuantidadeFoiPressionado) {
                        $(`#txtQuebraModalAviamentos${index}`).focus()
                    }
                } catch { }
                finally {
                    enterCampoQuantidadeFoiPressionado = false
                }
            })

        let enterCampoQuebraFoiPressionado = false
        $(`#txtQuebraModalAviamentos${index}`)
            .on('keydown', function (e) {
                enterCampoQuebraFoiPressionado = (e.key === 'Enter')
                if (enterCampoQuebraFoiPressionado) {
                    e.preventDefault()
                    $(this).blur()
                }
            }).on('blur', function () {
                try {
                    const quebra = retornarValorMonetarioEmFloat(this.value)
                    const quantidade = retornarValorMonetarioEmFloat($(`#txtQuantidadeModalAviamentos${index}`).val())
                    const data = row.data()
                    const custo = retornarValorMonetarioEmFloat(data.custo)
                    const valor = retornarValorAviamento({ quebra, quantidade, custo })

                    if (!valor || isNaN(valor)) {
                        row.data({ ...data, quantidade: 0, quebra: 0, valor: 0 })
                    } else {
                        row.data({ ...data, quantidade, quebra, valor })
                    }
                    recalcularDadosTabelaModalAviamentos()

                    if (enterCampoQuebraFoiPressionado) {
                        $(`#txtCodigoModalAviamentos${index + 1}`)?.focus()
                    }
                } catch { }
                finally {
                    enterCampoQuebraFoiPressionado = false
                }
            })
    }

    async function atualizarAviamentoComDadosDoCodigoInformado(codigo, index, row) {
        try {
            const {
                descricao,
                unidade,
                custo: custoBruto,
                atualizadoEm,
            } = await buscarDadosAviamentoInformado(codigo)

            const rowData = row.data()
            const quebra = retornarValorMonetarioEmFloat($(`#txtQuebraModalAviamentos${index}`).val())
            const quantidade = retornarValorMonetarioEmFloat(rowData.quantidade)
            const custo = retornarValorMonetarioEmFloat(custoBruto)
            const valor = retornarValorAviamento({ custo, quebra, quantidade })
            const newData = {
                ...rowData,
                codigo,
                descricao,
                unidade,
                custo: retornarFloatFormatadoEmMonetario({ valor: custo, quantidadeCasasDecimais: 6 }),
                valor: retornarFloatFormatadoEmMonetario({ valor, quantidadeCasasDecimais: 6 }),
                atualizadoEm,
            }
            row.data(newData)
            recalcularDadosTabelaModalAviamentos()
        } catch (error) {
            msgErro('Ocorreu um erro ao buscar os dados.')
            console.error(error)
        }
    }

    function retornarValorAviamento({ quantidade, custo, quebra }) {
        if (quebra >= 100) {
            quebra = 99.999999
        }
        return (quantidade * custo) / ((100 - quebra) / 100)
    }

    function adicionarEventosAviamentos(table) {
        table.rows().every((index) => {
            const row = table.row(index)
            adicionarEventosBotoesAviamentos(index, row)
            adicionarEventosInputsAviamentos(index, row)
        })
    }

    async function buscarDadosAviamentoInformado(codigo) {
        const pesquisa = retornarPesquisaAviamentos(codigo)
        const result = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))
        return {
            descricao: result[0]?.DESCRICAO ?? '',
            unidade: result[0]?.UNIDADE ?? '',
            custo: result[0]?.CUSTO ?? 0,
            atualizadoEm: result[0]?.DT_ULT_ATUALIZACAO ?? '',
        }
    }

    $('#btnIncluirModalAviamentos').on('click', function () {
        adicionarAviamento()
    })

    function adicionarAviamento(data) {
        let table = $('#tabelaModalAviamentos').DataTable()
        if (!data) {
            const ordem = table.data().toArray().reduce((acc, item) => acc < item.ordem ? item.ordem : acc, 0) + 1
            const acumulado = table.data().toArray().reduce((acc, item) => acc += retornarValorMonetarioEmFloat(item.valor), 0)
            data = {
                ordem,
                codigo: '',
                descricao: '',
                unidade: '',
                quantidade: 0,
                custo: 0,
                quebra: 0,
                valor: 0,
                acumulado,
                atualizadoEm: '',
            }
        }
        table.row.add(data)
        const index = table.rows().count() - 1
        recalcularDadosTabelaModalAviamentos()
        table = $('#tabelaModalAviamentos').DataTable()
        const row = table.row(index)
        if (row.node()) {
            table.rows().deselect()
            row.select()
            setTimeout(() => {
                $(row.node()).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
            }, 150)
        }
    }

    function recalcularDadosTabelaModalAviamentos() {
        const table = $('#tabelaModalAviamentos').DataTable()
        const data = table.data().toArray()
        let acumulado = 0

        const novosDados = data.map((item, idx) => {
            const valor = retornarValorMonetarioEmFloat(item?.valor)
            acumulado += valor
            return {
                ...item,
                acumulado,
                ordem: idx + 1,
            }
        })

        criarTabelaModalAviamentos(novosDados)
    }

    $('#btnComposicaoModalAviamentos').on('click', async function () {
        const codigo = $('#txtCodigo').val()
        if ($('#tabelaModalAviamentos').DataTable().data().length > 0) {
            msgAlerta('Já existem registros para esse cadastro, deseja refazer?', () => {
                carregarComposicaoMaterial(codigo)
            })
            return
        }
        carregarComposicaoMaterial(codigo)
    });

    async function carregarComposicaoMaterial(codigo) {
        $.LoadingOverlay('show')
        buscarComposicaoMaterial(codigo)
            .then(({ aviamentos }) => {
                criarTabelaModalAviamentos(aviamentos)
            })
            .catch((error) => {
                console.error(error)
                msgErro('Ocorreu um erro ao carregar os dados.')
            })
            .finally(() => $.LoadingOverlay('hide'))
    }

    async function buscarComposicaoMaterial(codigo) {
        const response = await requisicao("GET", `/sisplan/cadmatpreco/v1/composicao?`, `CODIGO=${encodeURIComponent(codigo)}`, '', 3600000)

        const json = await response.json()

        if (json) {
            const { resultado, mensagem } = json
            if (mensagem?.codigo !== 200) {
                throw mensagem?.mensagem
            }

            return resultado
        }
    }

    $('#btnConfirmarModalAviamentos').on('click', function () {
        try {
            const aviamentos = $('#tabelaModalAviamentos').DataTable().data().toArray().filter(item => item.valor && item.valor > 0)
            const totalCustoAviamentos = aviamentos?.reduce((acc, aviamento) => acc + aviamento.valor, 0) ?? 0
            const valoresCalcularCusto = retornarValoresCalcularCusto()
            const custoCalculado = retornarCustoCalculado({ ...valoresCalcularCusto, precoCompra: totalCustoAviamentos })
            $('#txtPreco1').val(retornarFloatFormatadoEmMonetario({ valor: custoCalculado, quantidadeCasasDecimais: 6 }))
            $('#txtPrecoCompra').val(retornarFloatFormatadoEmMonetario({ valor: totalCustoAviamentos, quantidadeCasasDecimais: 6 }))
            criarTabelaAviamentos(aviamentos)
            $('#modalAviamentos').modal('hide')
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao confirmar os dados.')
        }
    });

    $('#btnVoltar').on('click', function () {
        window.location.href = `${BASE_URI}/cadmatpreco`
    })

    function aplicarEstilosCamposDecimais() {
        $('.quatroCasasDecimaisQuantityFormat').off('input')
        $('.quatroCasasDecimaisQuantityFormat').on('input', function () {
            let val = $(this).val()
            val = val.replace('.', ',')
            val = val.replace(/[^0-9,]/g, '')
            const parts = val.split(',')
            if (parts.length > 2) {
                val = parts[0] + ',' + parts.slice(1).join('')
            }
            if (parts[1]?.length > 4) {
                parts[1] = parts[1].slice(0, 4)
                val = parts.join(',')
            }

            $(this).val(val)
        })
    }

    aplicarEstilosCamposDecimais()
});