$(document).ready(async function () {

    let produto;
    let id;

    $('#modal-obsmontagem').on('shown.bs.modal', async function () {
        $.LoadingOverlay('show');
        try {
            produto = $('#txtCodigo').val();
            id = parseInt($('#txtIdObsMontagem').val());
            $('#tituloObsMontagem').html(`${$('#txtCodigo').val()} - ${$('#txtDescricao').val()}`);
            criaRichText('#editor2');
            await buscaDados();

            $('#txtSetorObsMontagem').autocompleta(1, 'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
            $('#btnSetorObsMontagem').pesquisa_serverside(['#txtSetorObsMontagem'], ['CODIGO'], ['DESCRICAO'], '{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Setor');
            $('#txtCorObsMontagem').autocompleta(1, 'JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
            $('#btnCorObsMontagem').pesquisa_serverside(['#txtCorObsMontagem'], ['COR'], ['DESCRICAO'], `{"tabela":"CADCOR", "camposSelect":["COR", "DESCRICAO"], "where": null}`, 'Pesquisa de Cor');

            $('#btnLimpaSetorObsMontagem').on('click', function () {
                $('#txtSetorObsMontagem').val('');
            });

            $('#btnLimpaCorObsMontagem').on('click', function () {
                $('#txtCorObsMontagem').val('');
            });

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function retornaProximaOrdem() {
        try {
            const pesquisa = {
                tabela: "OBS_MONT_PROD",
                camposSelect: ["COALESCE(MAX(OBS_MONT_PROD.ORDEM), 0) ORDEM"],
                where: [`1=1 AND OBS_MONT_PROD.CODIGO = '${produto}'`]
            };

            const dados = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (!dados) {
                return;
            }

            return dados[0].ORDEM + 1;

        } catch (e) {
            console.log(e);
        }
    }

    async function buscaDados() {
        try {
            const pesquisa = {
                tabela: "OBS_MONT_PROD",
                camposSelect: ["OBS_MONT_PROD.*", "CADFLUXO.DESCRICAO DESC_SETOR", "CADCOR.DESCRICAO DESC_COR"],
                leftjoin: [{ tabela: "CADFLUXO", condicao: "OBS_MONT_PROD.SETOR = CADFLUXO.CODIGO" },
                { tabela: "CADCOR", condicao: "OBS_MONT_PROD.COR = CADCOR.COR" }],
                where: [`OBS_MONT_PROD.CODIGO = '${produto}'`, `OBS_MONT_PROD.ID = ${id}`]
            };

            const dados = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (!dados) {
                return;
            }

            if (dados.length == 0) {
                $('#txtOrdemObsMontagem').val(await retornaProximaOrdem());
                $('#txtDataObsMontagem').val(formataData(new Date()));
            } else {
                $('#txtOrdemObsMontagem').val(dados[0].ORDEM);
                $('#txtDataObsMontagem').val(formataData(new Date(dados[0].DATA + 'T12:00:00')));
                insereValor('#txtSetorObsMontagem', dados[0].SETOR, dados[0].DESC_SETOR);
                insereValor('#txtCorObsMontagem', dados[0].COR, dados[0].DESC_COR);
                $('#editor2 .ql-editor').html(formataHtml(dados[0].OBS));
            }

        } catch (e) {
            console.log(e);
        }
    }

    $('#btnCancelarObsMontagem').on('click', function () {
        msgAlerta('Tem certeza que deseja cancelar as alterações?', () => { }, () => { }, () => { $('#modal-obsmontagem').modal('hide') });
    });

    $('#modal-obsmontagem').on('hide.bs.modal', function () {
        $('#divTextoEdit').empty();
        $('#divTextoEdit').append('<div id="editor2"></div>');
        $('#txtIdObsMontagem').val('');
        $('#txtOrdemObsMontagem').val('');
        $('#txtDataObsMontagem').val('');
        $('#txtSetorObsMontagem').val('');
        $('#txtCorObsMontagem').val('');

        $('#txtSetorObsMontagem').off('autocompleta');
        $('#btnSetorObsMontagem').off('pesquisa_serverside');
        $('#txtCorObsMontagem').off('autocompleta');
        $('#btnCorObsMontagem').off('pesquisa_serverside');
    });

    $('#btnGravarObsMontagem').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            let ordem = await buscaValor('OBS_MONT_PROD', 'ORDEM', `CODIGO = '${produto}' AND ORDEM`, $('#txtOrdemObsMontagem').val());
            if (id == '0') {
                if (ordem && ordem != undefined && ordem != '') {
                    msgErro('Ordem já existe ou não foi informada. Impossível continuar.');
                    return;
                }
            }

            await gravaDados();

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function gravaDados() {
        try {
            let obj = {};

            const htmlContent = $('#editor2 .ql-editor').html();
            // const rtfContent = htmlToRtf(htmlContent);

            // let rtfContent = convertHtmlToRtf(htmlContent.replace(/^\s{8}|\s+$/mg, "").replace(/^\s+/, "").replace(/[ ]{4}/g, "  "));

            obj.CODIGO = produto;
            obj.ORDEM = parseInt($('#txtOrdemObsMontagem').val());
            obj.OBS = htmlContent;
            obj.DATA = $('#txtDataObsMontagem').val();
            obj.SETOR = pegaChave('#txtSetorObsMontagem');
            obj.COR = pegaChave('#txtCorObsMontagem');
            obj.ID = id;
            obj.DATA_ALT = id == '0' ? '1899-01-01' : formataData(new Date());
            obj.USUARIO = getCookie('usuario');

            let response = await requisicao("POST", `/Sisplan/Cadastros/V1/obsmontagem?`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(obj))}`);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            }

            toastr
                .success("Cadastro efetuado com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    async onHidden() {
                        $('#modal-obsmontagem').modal('hide');
                    },
                })
                .css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

        } catch (e) {
            console.log(`Não foi possível gravar os dados: ${e}`);
        }
    }
});