$(document).ready(async function () {

    let estaAlterando = false;
    let estaIncluindo = false;

    $('#btnAdicionaHist').on('click', async function () {
        estaIncluindo = true;
        estaAlterando = false;
        await desbloqueiaCampos();
        await limpaCampos();
        $('#cbTipoSolLine').prop('disabled', false);
        $('#cbTipoSolLine').prop('checked', true);
        $('#cbTipoSolPlanilha').prop('disabled', false);
        $('#cbTipoSolCusto').prop('disabled', false);
        $('#cbTipoSolLicenciador').prop('disabled', false);
        $('#cbTipoSolProducao').prop('disabled', false);
        $('#cbSituacaoPendente').prop('disabled', false);
        $('#cbSituacaoPendente').prop('checked', true);
        $('#cbSituacaoConcluido').prop('disabled', false);
        $('#tabelaHistProd').dataTable().$('tr.selected').removeClass('selected');
        await apareceBotaoGravarECancelar();
    });

    $('#btnGravaHist').on('click', async function () {
        if (estaIncluindo === true) {
            await incluiNovoRegistro();
        };

        if (estaAlterando === true) {
            await alteraRegistro();
        };
    });

    $('#btnImprimir').on('click', async function () {
        if (await existeRegistroNoDataTable()) {
            await imprimeRelatorio();
        } else {
            msgAlerta('Não existe registro para impressão! Verifique.');
            return;
        }
    })

    $('#btnAlterarHist').on('click', async function () {
        if (await existeRegistroNoDataTable()) {
            estaAlterando = true;
            estaIncluindo = false;
            await desbloqueiaCampos();
            await apareceBotaoGravarECancelar();
        } else  {
            msgAlerta('Não existe registro para alterar! Verifique.');
        }
        
    });

    $('#btnExcluir').on('click', async function () {
        const qtdeRegistros = $('#tabelaHistProd').DataTable().data().toArray().length;

        if (qtdeRegistros <= 0) {
            msgAlerta('Não há registro para exclusão!');
            return;
        }
        msgAlerta('Você realmente deseja excluir o registro selecionado?', async () => {
            await excluiRegistro();
        })
    });

    $('#btnLimpaSetor').on('click', function () {
        $('#txtSetor').val('');
    });

    $('#btnLimpaTema').on('click', function () {
        $('#txtTema').val('');
    })

    $('#btnCancelarAlteracao').on('click', async function () {
        estaAlterando = false;
        estaIncluindo = false;
        await bloqueiaCampos();
        await someBotaoGravarECancelar();
        await consultaHistorico();
        if (await existeRegistroNoDataTable()) {
            await selectPrimeiraLinha();
            await carregaInformacoes();
        } else {
            await limpaCampos();
        }
    })

    $('#modal-histprod').on('hide.bs.modal', async function () {
        estaAlterando = false;
        estaIncluindo = false;
        await bloqueiaCampos();
        await someBotaoGravarECancelar();
    });

    $('#modal-histprod').on('show.bs.modal', async function () {
        await consultaHistorico();
        criaPesquisaeAutocompleta();
        if (await existeRegistroNoDataTable()) {
            await selectPrimeiraLinha();
            await carregaInformacoes();
        } else {
            await limpaCampos();
        }
    });

    async function consultaHistorico() {

        if ($.fn.DataTable.isDataTable('#tabelaHistProd')) {
            $('#tabelaHistProd').DataTable().destroy();
            $('#tabelaHistProd').empty();
        };

        const tipoBase = await retornaDatabase();
        const codigoProd = $('#txtTituloProduto').val();
        let dataSetCols = [];
        let dataSetInfos = [];
        let dataSetInfosDataTable = [];
        let x = 0;

        let obs;
        if (tipoBase === 'ORACLE') {
            obs = 'CAST(utl_raw.cast_to_varchar2(HIST_PROD.OBS) AS VARCHAR (1024)) OBS'
        } else {
            obs = 'CAST(HIST_PROD.OBS AS VARCHAR (5000)) OBS'
        }

        const pesquisaParam = {
            tabela: 'HIST_PROD',
            camposSelect: ['HIST_PROD.ORDEM',
                'HIST_PROD.DATA',
                obs,
                'HIST_PROD.USUARIO',
                `HIST_PROD.DATA_SOLICITACAO`,
                'HIST_PROD.MODIFICACAO',
                'HIST_PROD.TP_SOLICITACAO',
                'HIST_PROD.MODIFICACAO2',
                'HIST_PROD.MODIFICACAO3',
                'HIST_PROD.MODIFICACAO4',
                'HIST_PROD.SETOR',
                'HIST_PROD.TEMA',
                'HIST_PROD.SITUACAO'
            ],
            where: [`HIST_PROD.PRODUTO = '${codigoProd}'`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        dataSetCols.push({
            'title': 'ORDEM'
        });
        dataSetCols.push({
            'title': 'DATA'
        });
        dataSetCols.push({
            'title': 'OBS'
        });
        dataSetCols.push({
            'title': 'USUÁRIO'
        });
        dataSetCols.push({
            'title': 'DATA SOLICITAÇÃO'
        });
        dataSetCols.push({
            'title': 'MODIFICAÇÃO'
        });
        dataSetCols.push({
            'title': 'TP SOLICITAÇÃO'
        });
        dataSetCols.push({
            'title': 'MODIFICAÇÃO 2'
        });
        dataSetCols.push({
            'title': 'MODIFICAÇÃO 3'
        });
        dataSetCols.push({
            'title': 'MODIFICAÇÃO 4'
        });
        dataSetCols.push({
            'title': 'SETOR'
        });
        dataSetCols.push({
            'title': 'TEMA'
        });
        dataSetCols.push({
            'title': 'SITUAÇÃO'
        });


        if (jsonStr.length > 0) {

            while (1 == 1) {

                if (jsonStr.length === x) {
                    break;
                }

                const ordem = jsonStr[x].ORDEM;
                const data = jsonStr[x].DATA.slice(0, 10);
                const observacao = jsonStr[x].OBS;
                const usuario = jsonStr[x].USUARIO;
                const data_solic = jsonStr[x].DATA_SOLICITACAO.slice(0, 10);
                const modificacao = jsonStr[x].MODIFICACAO;
                const tp_solicitacao = jsonStr[x].TP_SOLICITACAO;
                const modificacao2 = jsonStr[x].MODIFICACAO2;
                const modificacao3 = jsonStr[x].MODIFICACAO3;
                const modificacao4 = jsonStr[x].MODIFICACAO4;
                const setor = jsonStr[x].SETOR;
                const tema = jsonStr[x].TEMA;
                const situacao = jsonStr[x].SITUACAO;

                dataSetInfos.push(` <div class="input-group">
            <input type="text" readonly class="input-default focus form-control"
            id="txtOrdemInfo${x}" value="${ordem}"></input>  `);
                dataSetInfos.push(`  <input type="date" readonly class="input-default focus form-control"
            id="txtDataInfo${x}" value="${data}"></input>  `);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtObservacaoInfo${x}" value="${observacao}"></input>  `);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtUsuarioInfo${x}" value="${usuario}"></input>  `);
                dataSetInfos.push(`  <input type="date" readonly class="input-default focus form-control"
            id="txtDataSolicitacaoInfo${x}" value="${data_solic}"></input>  `);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtModificacaoInfo${x}" value="${modificacao}"></input>  `);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtTPSolicitacaoInfo${x}" value="${tp_solicitacao}"></input>  `);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtModificacao2Info${x}" value="${modificacao2}"></input>  `);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtModificacao3Info${x}" value="${modificacao3}"></input>  `);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtModificacao4Info${x}" value="${modificacao4}"></input>  `);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtSetorInfo${x}" value="${setor}"></input>  `);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtTemaInfo${x}" value="${tema}"></input>`);
                dataSetInfos.push(`  <input type="text" readonly class="input-default focus form-control"
            id="txtSituacaoInfo${x}" value="${situacao}"></input>
            </div>  `);
                dataSetInfosDataTable.push(dataSetInfos);
                dataSetInfos = [];
                x++
            }
        }

        $("#tabelaHistProd").DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            serverside: false,
            order: true,

            autoWidth: true,
            columns: dataSetCols,
            data: dataSetInfosDataTable,
            columnDefs: [{
                target: "11",
                visible: false,
            }]
        })

        $('#tabelaHistProd tbody').unbind('click');
        $('#tabelaHistProd tbody').on('click', 'tr', async function () {

            if (estaAlterando || estaIncluindo) {
                msgAlerta('Tem um registro já em alteração!');
                return;
            }

            $("#tabelaHistProd").dataTable().$("tr.selected").removeClass("selected");
            $(this).addClass("selected");
            await carregaInformacoes();
        });
    };

    async function selectPrimeiraLinha() {

        if (!await existeRegistroNoDataTable()) {
            return;
        };

        $($('#tabelaHistProd tbody tr')[0]).addClass('selected');
    };

    async function carregaInformacoes() {

        if (!await existeRegistroNoDataTable()) {
            return;
        }

        const indiceSelecionado = $($('#tabelaHistProd tr.selected')[0]).index();

        $('#txtData').val($(`#txtDataInfo${indiceSelecionado}`).val());
        $('#txtDataSolicitacao').val($(`#txtDataSolicitacaoInfo${indiceSelecionado}`).val());
        $('#txtObs').val($(`#txtObservacaoInfo${indiceSelecionado}`).val());
        $('#txtSetor').val($(`#txtSetorInfo${indiceSelecionado}`).val());
        $('#txtTema').val($(`#txtTemaInfo${indiceSelecionado}`).val());

        const modificacao1 = $(`#txtModificacaoInfo${indiceSelecionado}`).val();
        const modificacao2 = $(`#txtModificacao2Info${indiceSelecionado}`).val();
        const modificacao3 = $(`#txtModificacao3Info${indiceSelecionado}`).val();
        const modificacao4 = $(`#txtModificacao4Info${indiceSelecionado}`).val();

        $('#selectModificacao1').val(modificacao1);
        $('#selectModificacao2').val(modificacao2);
        $('#selectModificacao3').val(modificacao3);
        $('#selectModificacao4').val(modificacao4);

        const situacao = $(`#txtSituacaoInfo${indiceSelecionado}`).val();

        if (situacao == 'P') {
            $('#cbSituacaoConcluido').prop('checked', false);
            $('#cbSituacaoPendente').prop('checked', true);
            $('#cbSituacaoConcluido').prop('disabled', true);
            $('#cbSituacaoPendente').prop('disabled', false);
        } else {
            $('#cbSituacaoConcluido').prop('checked', true);
            $('#cbSituacaoPendente').prop('checked', false);
            $('#cbSituacaoConcluido').prop('disabled', false);
            $('#cbSituacaoPendente').prop('disabled', true);
        }

        const tpSolicitacao = $(`#txtTPSolicitacaoInfo${indiceSelecionado}`).val();

        if (tpSolicitacao == '1') {
            $(`#cbTipoSolLine`).prop('checked', true);
            $(`#cbTipoSolPlanilha`).prop('checked', false);
            $(`#cbTipoSolCusto`).prop('checked', false);
            $(`#cbTipoSolLicenciador`).prop('checked', false);
            $(`#cbTipoSolProducao`).prop('checked', false);
            $(`#cbTipoSolLine`).prop('disabled', false);
            $(`#cbTipoSolPlanilha`).prop('disabled', true);
            $(`#cbTipoSolCusto`).prop('disabled', true);
            $(`#cbTipoSolLicenciador`).prop('disabled', true);
            $(`#cbTipoSolProducao`).prop('disabled', true);
        } else if (tpSolicitacao == '2') {
            $(`#cbTipoSolLine`).prop('checked', false);
            $(`#cbTipoSolPlanilha`).prop('checked', true);
            $(`#cbTipoSolCusto`).prop('checked', false);
            $(`#cbTipoSolLicenciador`).prop('checked', false);
            $(`#cbTipoSolProducao`).prop('checked', false);
            $(`#cbTipoSolLine`).prop('disabled', true);
            $(`#cbTipoSolPlanilha`).prop('disabled', false);
            $(`#cbTipoSolCusto`).prop('disabled', true);
            $(`#cbTipoSolLicenciador`).prop('disabled', true);
            $(`#cbTipoSolProducao`).prop('disabled', true);
        } else if (tpSolicitacao == '3') {
            $(`#cbTipoSolLine`).prop('checked', false);
            $(`#cbTipoSolPlanilha`).prop('checked', false);
            $(`#cbTipoSolCusto`).prop('checked', true);
            $(`#cbTipoSolLicenciador`).prop('checked', false);
            $(`#cbTipoSolProducao`).prop('checked', false);
            $(`#cbTipoSolLine`).prop('disabled', true);
            $(`#cbTipoSolPlanilha`).prop('disabled', true);
            $(`#cbTipoSolCusto`).prop('disabled', false);
            $(`#cbTipoSolLicenciador`).prop('disabled', true);
            $(`#cbTipoSolProducao`).prop('disabled', true);
        } else if (tpSolicitacao == '4') {
            $(`#cbTipoSolLine`).prop('checked', false);
            $(`#cbTipoSolPlanilha`).prop('checked', false);
            $(`#cbTipoSolCusto`).prop('checked', false);
            $(`#cbTipoSolLicenciador`).prop('checked', true);
            $(`#cbTipoSolProducao`).prop('checked', false);
            $(`#cbTipoSolLine`).prop('disabled', true);
            $(`#cbTipoSolPlanilha`).prop('disabled', true);
            $(`#cbTipoSolCusto`).prop('disabled', true);
            $(`#cbTipoSolLicenciador`).prop('disabled', false);
            $(`#cbTipoSolProducao`).prop('disabled', true);
        } else {
            $(`#cbTipoSolLine`).prop('checked', false);
            $(`#cbTipoSolPlanilha`).prop('checked', false);
            $(`#cbTipoSolCusto`).prop('checked', false);
            $(`#cbTipoSolLicenciador`).prop('checked', false);
            $(`#cbTipoSolProducao`).prop('checked', true);
            $(`#cbTipoSolLine`).prop('disabled', true);
            $(`#cbTipoSolPlanilha`).prop('disabled', true);
            $(`#cbTipoSolCusto`).prop('disabled', true);
            $(`#cbTipoSolLicenciador`).prop('disabled', true);
            $(`#cbTipoSolProducao`).prop('disabled', false);
        };

        const codigoSetor = $(`#txtSetorInfo${indiceSelecionado}`).val();
        const codigoTema = $(`#txtTemaInfo${indiceSelecionado}`).val();

        if (codigoSetor !== '' && codigoSetor !== null) {
            const pesquisaSetor = {
                tabela: 'CADFLUXO',
                camposSelect: ['CADFLUXO.CODIGO',
                    'CADFLUXO.DESCRICAO'
                ],
                where: [`CADFLUXO.CODIGO = '${codigoSetor}'`]
            };
            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaSetor));
            const setorSelec = '[' + codigoSetor + '] - ' + jsonStr[0].DESCRICAO;
            $('#txtSetor').val(setorSelec);
        };

        if (codigoTema !== '' && codigoTema !== null) {
            const pesquisaTema = {
                tabela: 'MODELO',
                camposSelect: ['MODELO.CODIGO',
                    'MODELO.DESCRICAO'
                ],
                where: [`MODELO.CODIGO = '${codigoTema}'`]
            };
            const jsonStrTema = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaTema));
            const temaSelec = '[' + codigoTema + '] - ' + jsonStrTema[0].DESCRICAO;
            $('#txtTema').val(temaSelec);
        }
    }

    async function existeRegistroNoDataTable() {

        const qtde = $('#tabelaHistProd').DataTable().data().toArray().length;

        let existeRegistro;

        if (qtde > 0) {
            existeRegistro = true
        } else {
            existeRegistro = false;
        }

        return existeRegistro;
    };

    async function excluiRegistro() {

        const indiceSelecionado = $($('#tabelaHistProd tr.selected')[0]).index();
        const codigoProd = $('#txtTituloProduto').val();
        const ordem = $(`#txtOrdemInfo${indiceSelecionado}`).val();
        let response = await requisicao("DELETE", "/sisplan/histprod/v1/excluihistprod?", `CODIGOPROD=${codigoProd}&ORDEM=${ordem}`, null);
        if (response.status === 400) {
            msgAlerta('Não foi possível fazer a exclusão do registro!');
            return
        }
        if (response.status === 200) {
            criaMensagemSucesso('Registro selecionado foi excluído com sucesso!', () => { window.location.href = window.location.href; });
            return;
        }
    };

    async function incluiNovoRegistro() {

        const sProxOrdem = await buscaUltimaOrdem();
        const sProduto = $('#txtTituloProduto').val();
        const sData = $('#txtData').val();
        const sDataSolicitacao = $('#txtDataSolicitacao').val()
        const sSetor = pegaChave('#txtSetor');
        const sTema = pegaChave('#txtTema');
        const sObs = $('#txtObs').val();
        const sSituacao = $('#cbSituacaoPendente').is(':checked') ? 'P' : 'C';
        const sModificacao1 = $('#selectModificacao1').val();
        const sModificacao2 = $('#selectModificacao2').val() === null ? '' : $('#selectModificacao2').val();
        const sModificacao3 = $('#selectModificacao3').val() === null ? '' : $('#selectModificacao3').val();
        const sModificacao4 = $('#selectModificacao4').val() === null ? '' : $('#selectModificacao4').val();
        const sCodUsuario = getCookie('cod_usuario');
        let sUsuario;

        if (sObs === null || sObs === '') {
            msgErro('Campo observação é obrigatório!');
            return;
        };

        if (sModificacao1 === null || sModificacao1 === '') {
            msgErro('Campo modificação é obrigatório!');
            return;
        }

        if (sCodUsuario == '0000') {
            sUsuario = 'SISPLAN';
        } else {
            sUsuario = getCookie('usuario');
        }

        let sTipoSolicitacao;

        if ($('#cbTipoSolLine').is(':checked')) {
            sTipoSolicitacao = '1';
        } else if ($('#cbTipoSolPlanilha').is(':checked')) {
            sTipoSolicitacao = '2';
        } else if ($('#cbTipoSolCusto').is(':checked')) {
            sTipoSolicitacao = '3';
        } else if ($('#cbTipoSolLicenciador').is(':checked')) {
            sTipoSolicitacao = '4';
        } else if ($('#cbTipoSolProducao').is(':checked')) {
            sTipoSolicitacao = '5';
        }

        let histprod = {};

        histprod.ORDEM = parseInt(sProxOrdem);
        histprod.DATA = sData;
        histprod.PRODUTO = sProduto;
        histprod.DATA_SOLICITACAO = sDataSolicitacao;
        histprod.SETOR = sSetor;
        histprod.TEMA = sTema;
        histprod.OBS = sObs;
        histprod.SITUACAO = sSituacao;
        histprod.MODIFICACAO = sModificacao1;
        histprod.MODIFICACAO2 = sModificacao2;
        histprod.MODIFICACAO3 = sModificacao3;
        histprod.MODIFICACAO4 = sModificacao4;
        histprod.USUARIO = sUsuario;
        histprod.TP_SOLICITACAO = sTipoSolicitacao;

        let url = `/sisplan/histprod/v1/incluihistprod?`;
        let response = await requisicao("POST", url, `JSON=${JSON.stringify(histprod)}`, null);

        if (response.status === 400) {
            msgAlerta('Não foi possível fazer a inclusão do registro!');
            return
        }

        if (response.status === 200) {
            criaMensagemSucesso('Registro foi gravado com sucesso!', () => { window.location.href = window.location.href; });
            return;
        }
    };

    async function alteraRegistro() {

        const indiceSelected = $($('#tabelaHistProd tr.selected')[0]).index();

        const vOrdemSelecionada = $(`#txtOrdemInfo${indiceSelected}`).val();
        const vProduto = $('#txtTituloProduto').val();
        const vDataSelecionada = $('#txtData').val();
        const vDataSolicitacaoSelecionada = $('#txtDataSolicitacao').val()
        const vSetor = pegaChave('#txtSetor');
        const vTema = pegaChave('#txtTema');
        const vObs = $('#txtObs').val();
        const vSituacao = $('#cbSituacaoPendente').is(':checked') ? 'P' : 'C';
        const vModificacao1 = $('#selectModificacao1').val();
        const vModificacao2 = $('#selectModificacao2').val() === null ? '' : $('#selectModificacao2').val();
        const vModificacao3 = $('#selectModificacao3').val() === null ? '' : $('#selectModificacao3').val();
        const vModificacao4 = $('#selectModificacao4').val() === null ? '' : $('#selectModificacao4').val();
        const vCodUsuario = getCookie('cod_usuario');
        let vUsuario;

        if (vObs === null || vObs === '') {
            msgErro('Campo observação é obrigatório!');
            return;
        };

        if (vModificacao1 === null || vModificacao1 === '') {
            msgErro('Campo modificação é obrigatório!');
            return;
        }

        if (vCodUsuario == '0000') {
            vUsuario = 'SISPLAN';
        } else {
            vUsuario = getCookie('usuario');
        }

        let vTipoSolicitacao;

        if ($('#cbTipoSolLine').is(':checked')) {
            vTipoSolicitacao = '1';
        } else if ($('#cbTipoSolPlanilha').is(':checked')) {
            vTipoSolicitacao = '2';
        } else if ($('#cbTipoSolCusto').is(':checked')) {
            vTipoSolicitacao = '3';
        } else if ($('#cbTipoSolLicenciador').is(':checked')) {
            vTipoSolicitacao = '4';
        } else if ($('#cbTipoSolProducao').is(':checked')) {
            vTipoSolicitacao = '5';
        }

        let histprodaltera = {};

        histprodaltera.ORDEM = parseInt(vOrdemSelecionada);
        histprodaltera.DATA = vDataSelecionada;
        histprodaltera.PRODUTO = vProduto;
        histprodaltera.DATA_SOLICITACAO = vDataSolicitacaoSelecionada;
        histprodaltera.SETOR = vSetor;
        histprodaltera.TEMA = vTema;
        histprodaltera.OBS = vObs;
        histprodaltera.SITUACAO = vSituacao;
        histprodaltera.MODIFICACAO = vModificacao1;
        histprodaltera.MODIFICACAO2 = vModificacao2;
        histprodaltera.MODIFICACAO3 = vModificacao3;
        histprodaltera.MODIFICACAO4 = vModificacao4;
        histprodaltera.USUARIO = vUsuario;
        histprodaltera.TP_SOLICITACAO = vTipoSolicitacao;

        let url = `/sisplan/histprod/v1/atualizahistprod?`;
        let response = await requisicao('PUT', url, `JSON=${JSON.stringify(histprodaltera)}`, null);

        if (response.status === 400) {
            msgAlerta('Não foi possível fazer a inclusão do registro!');
            return
        }

        if (response.status === 200) {
            criaMensagemSucesso('Registro foi gravado com sucesso!', () => { window.location.href = window.location.href; });
            return;
        }

    };

    async function imprimeRelatorio() {
        try {
            $.LoadingOverlay("show");
            try {
                const codigoProd = $('#txtTituloProduto').val();
                const url = `/sisplan/impressao/v1/imprimirhistprod?PRODUTO=${codigoProd}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('relhistoricoproduto');
                const arquivo = await GeraRelatorio(`${url}`, "GET", 100000, false, 'relhistoricoproduto');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    };

    async function buscaUltimaOrdem() {

        const codigoProd = $('#txtTituloProduto').val();

        const pesquisaParam = {
            tabela: 'HIST_PROD',
            camposSelect: ['MAX(HIST_PROD.ORDEM) AS ORDEM'
            ],
            where: [`HIST_PROD.PRODUTO = '${codigoProd}'`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        const maxOrdem = jsonStr[0].ORDEM === null ? -1 : parseInt(jsonStr[0].ORDEM);
        let proximaOrdem;

        if (maxOrdem >= 0) {
            proximaOrdem = maxOrdem + 1;
        } else {
            proximaOrdem = 0;
        }

        return proximaOrdem;
    };

    async function limpaCampos() {
        $('#txtData').val(new Date().toISOString().slice(0, 10));
        $('#txtDataSolicitacao').val(new Date().toISOString().slice(0, 10));
        $('#txtSetor').val('');
        $('#txtTema').val('');
        $('#txtObs').val('');
        $('#cbSituacaoPendente').prop('checked', false);
        $('#cbSituacaoConcluido').prop('checked', false);
        $('#cbSituacaoPendente').prop('disabled', true);
        $('#cbSituacaoConcluido').prop('disabled', true);
        $('#selectModificacao1').val('');
        $('#selectModificacao2').val('');
        $('#selectModificacao3').val('');
        $('#selectModificacao4').val('');
        $('#cbTipoSolLine').prop('checked', false);
        $('#cbTipoSolPlanilha').prop('checked', false);
        $('#cbTipoSolCusto').prop('checked', false);
        $('#cbTipoSolLicenciador').prop('checked', false);
        $('#cbTipoSolProducao').prop('checked', false);
        $('#cbTipoSolLine').prop('disabled', true);
        $('#cbTipoSolPlanilha').prop('disabled', true);
        $('#cbTipoSolCusto').prop('disabled', true);
        $('#cbTipoSolLicenciador').prop('disabled', true);
        $('#cbTipoSolProducao').prop('disabled', true);
    };
    async function apareceBotaoGravarECancelar() {
        $('#btnGravaHist').removeClass('d-none');
        $('#btnCancelarAlteracao').removeClass('d-none');
        $('#btnAdicionaHist').addClass('d-none');
        $('#btnAlterarHist').addClass('d-none');
        $('#btnExcluir').addClass('d-none');
        $('#btnImprimir').addClass('d-none');
    };
    async function someBotaoGravarECancelar() {
        $('#btnGravaHist').addClass('d-none');
        $('#btnCancelarAlteracao').addClass('d-none');
        $('#btnAdicionaHist').removeClass('d-none');
        $('#btnAlterarHist').removeClass('d-none');
        $('#btnExcluir').removeClass('d-none');
        $('#btnImprimir').removeClass('d-none');
    };
    async function desbloqueiaCampos() {
        $('#txtData').prop('disabled', false);
        $('#txtDataSolicitacao').prop('disabled', false);
        $('#txtSetor').prop('disabled', false);
        $('#btnConsultaSetor').prop('disabled', false);
        $('#txtData').prop('disabled', false);
        $('#btnLimpaSetor').prop('disabled', false);
        $('#txtObs').prop('disabled', false);
        $('#txtTema').prop('disabled', false);
        $('#btnConsultaTema').prop('disabled', false);
        $('#btnLimpaTema').prop('disabled', false);
        $('#cbSituacaoPendente').prop('disabled', false);
        $('#cbSituacaoConcluido').prop('disabled', false);
        $('#selectModificacao1').prop('disabled', false);
        $('#selectModificacao2').prop('disabled', false);
        $('#selectModificacao3').prop('disabled', false);
        $('#selectModificacao4').prop('disabled', false);
        $('#cbTipoSolLine').prop('disabled', false);
        $('#cbTipoSolPlanilha').prop('disabled', false);
        $('#cbTipoSolCusto').prop('disabled', false);
        $('#cbTipoSolLicenciador').prop('disabled', false);
        $('#cbTipoSolProducao').prop('disabled', false);
    };
    function criaPesquisaeAutocompleta() {
        $('#btnConsultaSetor').pesquisa_serverside(['#txtSetor'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADFLUXO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Setor');
        $('#txtSetor').autocompleta(1, 'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btnConsultaTema').pesquisa_serverside(['#txtTema'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"MODELO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Tema');
        $('#txtTema').autocompleta(1, 'JSON={ "tabela":"MODELO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
    };
    async function bloqueiaCampos() {
        $('#txtData').prop('disabled', true);
        $('#txtDataSolicitacao').prop('disabled', true);
        $('#txtSetor').prop('disabled', true);
        $('#btnConsultaSetor').prop('disabled', true);
        $('#txtData').prop('disabled', true);
        $('#btnLimpaSetor').prop('disabled', true);
        $('#txtObs').prop('disabled', true);
        $('#txtTema').prop('disabled', true);
        $('#btnConsultaTema').prop('disabled', true);
        $('#btnLimpaTema').prop('disabled', true);
        $('#selectModificacao1').prop('disabled', true);
        $('#selectModificacao2').prop('disabled', true);
        $('#selectModificacao3').prop('disabled', true);
        $('#selectModificacao4').prop('disabled', true);

        if (await existeRegistroNoDataTable()) {

            const indexRegistro = $($('#tabelaHistProd tr.selected')[0]).index();
            const situacaoIndex = $(`#txtSituacaoInfo${indexRegistro}`).val();
            const tipoSolIndex = $(`#txtTPSolicitacaoInfo${indexRegistro}`).val();

            if (situacaoIndex === 'P') {
                $('#cbSituacaoPendente').prop('checked', true);
                $('#cbSituacaoPendente').prop('disabled', false);
                $('#cbSituacaoConcluido').prop('checked', false);
                $('#cbSituacaoConcluido').prop('disabled', true);
            } else {
                $('#cbSituacaoPendente').prop('checked', false);
                $('#cbSituacaoPendente').prop('disabled', true);
                $('#cbSituacaoConcluido').prop('checked', true);
                $('#cbSituacaoConcluido').prop('disabled', false);
            }

            if (tipoSolIndex == '1') {
                $(`#cbTipoSolLine`).prop('checked', true);
                $(`#cbTipoSolPlanilha`).prop('checked', false);
                $(`#cbTipoSolCusto`).prop('checked', false);
                $(`#cbTipoSolLicenciador`).prop('checked', false);
                $(`#cbTipoSolProducao`).prop('checked', false);
                $(`#cbTipoSolLine`).prop('disabled', false);
                $(`#cbTipoSolPlanilha`).prop('disabled', true);
                $(`#cbTipoSolCusto`).prop('disabled', true);
                $(`#cbTipoSolLicenciador`).prop('disabled', true);
                $(`#cbTipoSolProducao`).prop('disabled', true);
            } else if (tipoSolIndex == '2') {
                $(`#cbTipoSolLine`).prop('checked', false);
                $(`#cbTipoSolPlanilha`).prop('checked', true);
                $(`#cbTipoSolCusto`).prop('checked', false);
                $(`#cbTipoSolLicenciador`).prop('checked', false);
                $(`#cbTipoSolProducao`).prop('checked', false);
                $(`#cbTipoSolLine`).prop('disabled', true);
                $(`#cbTipoSolPlanilha`).prop('disabled', false);
                $(`#cbTipoSolCusto`).prop('disabled', true);
                $(`#cbTipoSolLicenciador`).prop('disabled', true);
                $(`#cbTipoSolProducao`).prop('disabled', true);
            } else if (tipoSolIndex == '3') {
                $(`#cbTipoSolLine`).prop('checked', false);
                $(`#cbTipoSolPlanilha`).prop('checked', false);
                $(`#cbTipoSolCusto`).prop('checked', true);
                $(`#cbTipoSolLicenciador`).prop('checked', false);
                $(`#cbTipoSolProducao`).prop('checked', false);
                $(`#cbTipoSolLine`).prop('disabled', true);
                $(`#cbTipoSolPlanilha`).prop('disabled', true);
                $(`#cbTipoSolCusto`).prop('disabled', false);
                $(`#cbTipoSolLicenciador`).prop('disabled', true);
                $(`#cbTipoSolProducao`).prop('disabled', true);
            } else if (tipoSolIndex == '4') {
                $(`#cbTipoSolLine`).prop('checked', false);
                $(`#cbTipoSolPlanilha`).prop('checked', false);
                $(`#cbTipoSolCusto`).prop('checked', false);
                $(`#cbTipoSolLicenciador`).prop('checked', true);
                $(`#cbTipoSolProducao`).prop('checked', false);
                $(`#cbTipoSolLine`).prop('disabled', true);
                $(`#cbTipoSolPlanilha`).prop('disabled', true);
                $(`#cbTipoSolCusto`).prop('disabled', true);
                $(`#cbTipoSolLicenciador`).prop('disabled', false);
                $(`#cbTipoSolProducao`).prop('disabled', true);
            } else {
                $(`#cbTipoSolLine`).prop('checked', false);
                $(`#cbTipoSolPlanilha`).prop('checked', false);
                $(`#cbTipoSolCusto`).prop('checked', false);
                $(`#cbTipoSolLicenciador`).prop('checked', false);
                $(`#cbTipoSolProducao`).prop('checked', true);
                $(`#cbTipoSolLine`).prop('disabled', true);
                $(`#cbTipoSolPlanilha`).prop('disabled', true);
                $(`#cbTipoSolCusto`).prop('disabled', true);
                $(`#cbTipoSolLicenciador`).prop('disabled', true);
                $(`#cbTipoSolProducao`).prop('disabled', false);
            }
        }
    }
})